/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.appmaster;

import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.twill.api.TwillSpecification;

final class PlacementPolicyManager {
    private final Map<TwillSpecification.PlacementPolicy.Type, Set<String>> policyTypeToRunnables = new EnumMap<TwillSpecification.PlacementPolicy.Type, Set<String>>(TwillSpecification.PlacementPolicy.Type.class);
    private final Map<String, TwillSpecification.PlacementPolicy> runnablePolicies = new HashMap<String, TwillSpecification.PlacementPolicy>();

    PlacementPolicyManager(List<TwillSpecification.PlacementPolicy> policies) {
        for (TwillSpecification.PlacementPolicy policy : policies) {
            this.policyTypeToRunnables.put(policy.getType(), policy.getNames());
            for (String runnable : policy.getNames()) {
                this.runnablePolicies.put(runnable, policy);
            }
        }
    }

    Set<String> getDistributedRunnables() {
        Set<String> runnables = this.policyTypeToRunnables.get(TwillSpecification.PlacementPolicy.Type.DISTRIBUTED);
        return runnables == null ? Collections.emptySet() : runnables;
    }

    @Nullable
    TwillSpecification.PlacementPolicy getPlacementPolicy(String runnableName) {
        return this.runnablePolicies.get(runnableName);
    }
}

