/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.appmaster;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.HashMap;
import org.apache.twill.common.Cancellable;
import org.apache.twill.internal.ProcessController;
import org.apache.twill.internal.yarn.AbstractYarnProcessLauncher;
import org.apache.twill.internal.yarn.YarnContainerInfo;
import org.apache.twill.internal.yarn.YarnLaunchContext;
import org.apache.twill.internal.yarn.YarnNMClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RunnableProcessLauncher
extends AbstractYarnProcessLauncher<YarnContainerInfo> {
    private static final Logger LOG = LoggerFactory.getLogger(RunnableProcessLauncher.class);
    private final YarnContainerInfo containerInfo;
    private final YarnNMClient nmClient;
    private boolean launched;

    public RunnableProcessLauncher(YarnContainerInfo containerInfo, YarnNMClient nmClient) {
        super(containerInfo);
        this.containerInfo = containerInfo;
        this.nmClient = nmClient;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("container", (Object)this.containerInfo).toString();
    }

    @Override
    protected <R> ProcessController<R> doLaunch(YarnLaunchContext launchContext) {
        HashMap env = Maps.newHashMap(launchContext.getEnvironment());
        env.put("YARN_CONTAINER_ID", this.containerInfo.getId());
        env.put("YARN_CONTAINER_HOST", this.containerInfo.getHost().getHostName());
        env.put("YARN_CONTAINER_PORT", Integer.toString(this.containerInfo.getPort()));
        env.put("YARN_CONTAINER_MEMORY_MB", Integer.toString(this.containerInfo.getMemoryMB()));
        env.put("YARN_CONTAINER_VIRTUAL_CORES", Integer.toString(this.containerInfo.getVirtualCores()));
        launchContext.setEnvironment(env);
        LOG.info("Launching in container {} at {}:{}, {}", new Object[]{this.containerInfo.getId(), this.containerInfo.getHost().getHostName(), this.containerInfo.getPort(), launchContext.getCommands()});
        final Cancellable cancellable = this.nmClient.start(this.containerInfo, launchContext);
        this.launched = true;
        return new ProcessController<R>(){

            public void close() throws Exception {
            }

            public R getReport() {
                return null;
            }

            public void cancel() {
                cancellable.cancel();
            }
        };
    }

    public boolean isLaunched() {
        return this.launched;
    }
}

