/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.yarn;

import com.google.common.base.Throwables;
import org.apache.hadoop.conf.Configuration;
import org.apache.twill.internal.yarn.YarnAMClient;
import org.apache.twill.internal.yarn.YarnAMClientFactory;
import org.apache.twill.internal.yarn.YarnUtils;

public final class VersionDetectYarnAMClientFactory
implements YarnAMClientFactory {
    private final Configuration conf;

    public VersionDetectYarnAMClientFactory(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public YarnAMClient create() {
        try {
            Class<?> clz;
            switch (YarnUtils.getHadoopVersion()) {
                case HADOOP_21: {
                    String clzName = this.getClass().getPackage().getName() + ".Hadoop21YarnAMClient";
                    clz = Class.forName(clzName);
                    break;
                }
                case HADOOP_22: 
                case HADOOP_23: {
                    String clzName = this.getClass().getPackage().getName() + ".Hadoop22YarnAMClient";
                    clz = Class.forName(clzName);
                    break;
                }
                default: {
                    String clzName = this.getClass().getPackage().getName() + ".Hadoop26YarnAMClient";
                    clz = Class.forName(clzName);
                }
            }
            return (YarnAMClient)clz.getConstructor(Configuration.class).newInstance(this.conf);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

