/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.yarn;

import com.google.common.base.Throwables;
import org.apache.hadoop.conf.Configuration;
import org.apache.twill.internal.yarn.YarnAppClient;
import org.apache.twill.internal.yarn.YarnAppClientFactory;
import org.apache.twill.internal.yarn.YarnUtils;

public final class VersionDetectYarnAppClientFactory
implements YarnAppClientFactory {
    @Override
    public YarnAppClient create(Configuration configuration) {
        try {
            String clzName;
            switch (YarnUtils.getHadoopVersion()) {
                case HADOOP_21: 
                case HADOOP_22: {
                    clzName = this.getClass().getPackage().getName() + ".Hadoop21YarnAppClient";
                    break;
                }
                case HADOOP_23: {
                    clzName = this.getClass().getPackage().getName() + ".Hadoop23YarnAppClient";
                    break;
                }
                default: {
                    clzName = this.getClass().getPackage().getName() + ".Hadoop26YarnAppClient";
                }
            }
            Class<?> clz = Class.forName(clzName);
            return (YarnAppClient)clz.getConstructor(Configuration.class).newInstance(configuration);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

