/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.yarn;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.twill.api.LocalFile;
import org.apache.twill.filesystem.FileContextLocationFactory;
import org.apache.twill.filesystem.ForwardingLocationFactory;
import org.apache.twill.filesystem.LocationFactory;
import org.apache.twill.internal.yarn.Hadoop21YarnLaunchContext;
import org.apache.twill.internal.yarn.Hadoop21YarnLocalResource;
import org.apache.twill.internal.yarn.YarnLaunchContext;
import org.apache.twill.internal.yarn.YarnLocalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnUtils {
    private static final Logger LOG = LoggerFactory.getLogger(YarnUtils.class);
    private static boolean hasDFSUtilClient = false;
    private static boolean hasHAUtilsClient = false;
    private static Method getHaNnRpcAddressesMethod;
    private static Method cloneDelegationTokenForLogicalUriMethod;
    private static final AtomicReference<HadoopVersions> HADOOP_VERSION;

    public static YarnLocalResource createLocalResource(LocalFile localFile) {
        Preconditions.checkArgument((localFile.getLastModified() >= 0L ? 1 : 0) != 0, (Object)"Last modified time should be >= 0.");
        Preconditions.checkArgument((localFile.getSize() >= 0L ? 1 : 0) != 0, (Object)"File size should be >= 0.");
        Hadoop21YarnLocalResource resource = new Hadoop21YarnLocalResource();
        resource.setVisibility(LocalResourceVisibility.APPLICATION);
        resource.setResource(ConverterUtils.getYarnUrlFromURI((URI)localFile.getURI()));
        resource.setTimestamp(localFile.getLastModified());
        resource.setSize(localFile.getSize());
        return YarnUtils.setLocalResourceType(resource, localFile);
    }

    public static YarnLaunchContext createLaunchContext() {
        return new Hadoop21YarnLaunchContext();
    }

    public static int getVirtualCores(Resource resource) {
        try {
            Method getVirtualCores = Resource.class.getMethod("getVirtualCores", new Class[0]);
            return (Integer)getVirtualCores.invoke((Object)resource, new Object[0]);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static boolean setVirtualCores(Resource resource, int cores) {
        try {
            Method setVirtualCores = Resource.class.getMethod("setVirtualCores", Integer.TYPE);
            setVirtualCores.invoke((Object)resource, cores);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static List<Token<?>> addDelegationTokens(Configuration config, LocationFactory locationFactory, Credentials credentials) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            LOG.debug("Security is not enabled");
            return ImmutableList.of();
        }
        try (FileSystem fileSystem = YarnUtils.getFileSystem(locationFactory);){
            if (fileSystem == null) {
                ImmutableList immutableList = ImmutableList.of();
                return immutableList;
            }
            String renewer = YarnUtils.getYarnTokenRenewer(config);
            Object[] tokens = fileSystem.addDelegationTokens(renewer, credentials);
            LOG.debug("Added HDFS DelegationTokens: {}", (Object)Arrays.toString(tokens));
            ImmutableList immutableList = tokens == null ? ImmutableList.of() : ImmutableList.copyOf((Object[])tokens);
            return immutableList;
        }
    }

    public static void cloneHaNnCredentials(Configuration config) throws IOException {
        String scheme = URI.create(config.get("fs.defaultFS", "file:///")).getScheme();
        for (Map.Entry<String, Map<String, InetSocketAddress>> entry : YarnUtils.getHaNnRpcAddresses(config).entrySet()) {
            String nsId = entry.getKey();
            Map<String, InetSocketAddress> addressesInNN = entry.getValue();
            if (!HAUtil.isHAEnabled((Configuration)config, (String)nsId) || addressesInNN == null || addressesInNN.isEmpty()) continue;
            URI uri = URI.create(scheme + "://" + nsId);
            LOG.info("Cloning delegation token for uri {}", (Object)uri);
            YarnUtils.cloneDelegationTokenForLogicalUri(UserGroupInformation.getCurrentUser(), uri, addressesInNN.values());
        }
    }

    private static void cloneDelegationTokenForLogicalUri(UserGroupInformation ugi, URI haUri, Collection<InetSocketAddress> nnAddrs) {
        if (hasHAUtilsClient) {
            YarnUtils.invokeStaticMethodWithExceptionHandled(cloneDelegationTokenForLogicalUriMethod, ugi, haUri, nnAddrs);
        } else {
            HAUtil.cloneDelegationTokenForLogicalUri((UserGroupInformation)ugi, (URI)haUri, nnAddrs);
        }
    }

    private static Map<String, Map<String, InetSocketAddress>> getHaNnRpcAddresses(Configuration config) {
        return hasDFSUtilClient ? YarnUtils.getHaNnRpcAddressesUseDFSUtilClient(config) : DFSUtil.getHaNnRpcAddresses((Configuration)config);
    }

    private static Map<String, Map<String, InetSocketAddress>> getHaNnRpcAddressesUseDFSUtilClient(Configuration config) {
        return (Map)YarnUtils.invokeStaticMethodWithExceptionHandled(getHaNnRpcAddressesMethod, config);
    }

    private static Object invokeStaticMethodWithExceptionHandled(Method method, Object ... args) {
        Preconditions.checkNotNull((Object)method);
        try {
            return method.invoke(null, args);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(e.getMessage(), (Throwable)e);
            }
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static ByteBuffer encodeCredentials(Credentials credentials) {
        try {
            DataOutputBuffer out = new DataOutputBuffer();
            credentials.writeTokenStorageToStream((DataOutputStream)out);
            return ByteBuffer.wrap(out.getData(), 0, out.getLength());
        }
        catch (IOException e) {
            LOG.error("Failed to encode Credentials.", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Credentials decodeCredentials(ByteBuffer buffer) throws IOException {
        Credentials credentials = new Credentials();
        if (buffer != null && buffer.hasRemaining()) {
            DataInputByteBuffer in = new DataInputByteBuffer();
            in.reset(new ByteBuffer[]{buffer});
            credentials.readTokenStorageStream((DataInputStream)in);
        }
        return credentials;
    }

    public static String getYarnTokenRenewer(Configuration config) throws IOException {
        String rmHost = YarnUtils.getRMAddress(config).getHostName();
        String renewer = SecurityUtil.getServerPrincipal((String)config.get("yarn.resourcemanager.principal"), (String)rmHost);
        if (renewer == null || renewer.length() == 0) {
            throw new IOException("No Kerberos principal for Yarn RM to use as renewer");
        }
        return renewer;
    }

    public static InetSocketAddress getRMAddress(Configuration config) {
        return config.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
    }

    public static HadoopVersions getHadoopVersion() {
        HadoopVersions hadoopVersion = HADOOP_VERSION.get();
        if (hadoopVersion != null) {
            return hadoopVersion;
        }
        try {
            Class.forName("org.apache.hadoop.yarn.client.cli.LogsCLI");
            try {
                Class.forName("org.apache.hadoop.yarn.conf.HAUtil");
                try {
                    Class[] args = new Class[]{String.class};
                    Class.forName("org.apache.hadoop.yarn.api.records.ContainerId").getMethod("fromString", args);
                    HADOOP_VERSION.set(HadoopVersions.HADOOP_26);
                }
                catch (NoSuchMethodException e) {
                    HADOOP_VERSION.set(HadoopVersions.HADOOP_23);
                }
            }
            catch (ClassNotFoundException e) {
                HADOOP_VERSION.set(HadoopVersions.HADOOP_22);
            }
        }
        catch (ClassNotFoundException e) {
            HADOOP_VERSION.set(HadoopVersions.HADOOP_21);
        }
        return HADOOP_VERSION.get();
    }

    private static YarnLocalResource setLocalResourceType(YarnLocalResource localResource, LocalFile localFile) {
        if (localFile.isArchive()) {
            if (localFile.getPattern() == null) {
                localResource.setType(LocalResourceType.ARCHIVE);
            } else {
                localResource.setType(LocalResourceType.PATTERN);
                localResource.setPattern(localFile.getPattern());
            }
        } else {
            localResource.setType(LocalResourceType.FILE);
        }
        return localResource;
    }

    @Nullable
    private static FileSystem getFileSystem(LocationFactory locationFactory) throws IOException {
        if (locationFactory instanceof ForwardingLocationFactory) {
            return YarnUtils.getFileSystem(((ForwardingLocationFactory)locationFactory).getDelegate());
        }
        if (locationFactory instanceof FileContextLocationFactory) {
            Configuration config = new Configuration(((FileContextLocationFactory)locationFactory).getConfiguration());
            String scheme = FileSystem.getDefaultUri((Configuration)config).getScheme();
            config.set(String.format("fs.%s.impl.disable.cache", scheme), "true");
            return FileSystem.get((Configuration)config);
        }
        LOG.warn("Unexpected: LocationFactory is not backed by FileContextLocationFactory");
        return null;
    }

    private YarnUtils() {
    }

    static {
        try {
            Class<?> dfsUtilsClientClazz = Class.forName("org.apache.hadoop.hdfs.DFSUtilClient");
            getHaNnRpcAddressesMethod = dfsUtilsClientClazz.getMethod("getHaNnRpcAddresses", Configuration.class);
            hasDFSUtilClient = true;
            Class<?> haUtilClientClazz = Class.forName("org.apache.hadoop.hdfs.HAUtilClient");
            cloneDelegationTokenForLogicalUriMethod = haUtilClientClazz.getMethod("cloneDelegationTokenForLogicalUri", UserGroupInformation.class, URI.class, Collection.class);
            hasHAUtilsClient = true;
        }
        catch (ClassNotFoundException e) {
            LOG.debug("No such class", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            LOG.debug("No such method", (Throwable)e);
        }
        HADOOP_VERSION = new AtomicReference();
    }

    public static enum HadoopVersions {
        HADOOP_21,
        HADOOP_22,
        HADOOP_23,
        HADOOP_26;

    }
}

