/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.yarn;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import org.apache.twill.api.ResourceReport;
import org.apache.twill.internal.json.ResourceReportAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ResourceReportClient {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceReportClient.class);
    private final ResourceReportAdapter reportAdapter;
    private final List<URL> resourceUrls;

    ResourceReportClient(List<URL> resourceUrls) {
        this.resourceUrls = resourceUrls;
        this.reportAdapter = ResourceReportAdapter.create();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResourceReport get() {
        Iterator<URL> iterator = this.resourceUrls.iterator();
        while (iterator.hasNext()) {
            URL url = iterator.next();
            try {
                HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
                urlConn.setRequestProperty("Accept-Encoding", "gzip, deflate");
                if (urlConn.getResponseCode() != 200) continue;
                try (InputStreamReader reader = new InputStreamReader(this.getInputStream(urlConn), StandardCharsets.UTF_8);){
                    LOG.trace("Report returned by {}", (Object)url);
                    ResourceReport resourceReport = this.reportAdapter.fromJson((Reader)reader);
                    return resourceReport;
                }
            }
            catch (IOException e) {
                LOG.trace("Exception raised when getting resource report from {}.", (Object)url, (Object)e);
            }
        }
        return null;
    }

    private InputStream getInputStream(HttpURLConnection urlConn) throws IOException {
        InputStream is = urlConn.getInputStream();
        String contentEncoding = urlConn.getContentEncoding();
        if (contentEncoding == null) {
            return is;
        }
        if ("gzip".equalsIgnoreCase(contentEncoding)) {
            return new GZIPInputStream(is);
        }
        if ("deflate".equalsIgnoreCase(contentEncoding)) {
            return new DeflaterInputStream(is);
        }
        throw new IOException("Unsupported content encoding " + contentEncoding);
    }
}

