/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.yarn;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Service;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.twill.api.LocalFile;
import org.apache.twill.api.ResourceSpecification;
import org.apache.twill.api.RunId;
import org.apache.twill.api.SecureStore;
import org.apache.twill.api.SecureStoreUpdater;
import org.apache.twill.api.TwillApplication;
import org.apache.twill.api.TwillController;
import org.apache.twill.api.TwillPreparer;
import org.apache.twill.api.TwillRunnable;
import org.apache.twill.api.TwillRunner;
import org.apache.twill.api.TwillRunnerService;
import org.apache.twill.api.TwillSpecification;
import org.apache.twill.api.logging.LogHandler;
import org.apache.twill.api.security.SecureStoreRenewer;
import org.apache.twill.api.security.SecureStoreWriter;
import org.apache.twill.common.Cancellable;
import org.apache.twill.common.Threads;
import org.apache.twill.filesystem.FileContextLocationFactory;
import org.apache.twill.filesystem.Location;
import org.apache.twill.filesystem.LocationFactory;
import org.apache.twill.internal.ProcessController;
import org.apache.twill.internal.RunIds;
import org.apache.twill.internal.SingleRunnableApplication;
import org.apache.twill.internal.appmaster.ApplicationMasterLiveNodeData;
import org.apache.twill.internal.io.BasicLocationCache;
import org.apache.twill.internal.io.LocationCache;
import org.apache.twill.internal.io.NoCachingLocationCache;
import org.apache.twill.internal.yarn.VersionDetectYarnAppClientFactory;
import org.apache.twill.internal.yarn.YarnAppClient;
import org.apache.twill.internal.yarn.YarnApplicationReport;
import org.apache.twill.yarn.ApplicationMasterLiveNodeDecoder;
import org.apache.twill.yarn.LocationCacheCleaner;
import org.apache.twill.yarn.LocationSecureStoreRenewer;
import org.apache.twill.yarn.YarnTwillController;
import org.apache.twill.yarn.YarnTwillControllerFactory;
import org.apache.twill.yarn.YarnTwillPreparer;
import org.apache.twill.zookeeper.NodeChildren;
import org.apache.twill.zookeeper.NodeData;
import org.apache.twill.zookeeper.OperationFuture;
import org.apache.twill.zookeeper.RetryStrategies;
import org.apache.twill.zookeeper.RetryStrategy;
import org.apache.twill.zookeeper.ZKClient;
import org.apache.twill.zookeeper.ZKClientService;
import org.apache.twill.zookeeper.ZKClientServices;
import org.apache.twill.zookeeper.ZKClients;
import org.apache.twill.zookeeper.ZKOperations;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class YarnTwillRunnerService
implements TwillRunnerService {
    private static final Logger LOG = LoggerFactory.getLogger(YarnTwillRunnerService.class);
    private static final int ZK_TIMEOUT = 10000;
    private static final Function<String, RunId> STRING_TO_RUN_ID = new Function<String, RunId>(){

        public RunId apply(String input) {
            return RunIds.fromString((String)input);
        }
    };
    private static final Function<YarnTwillController, TwillController> CAST_CONTROLLER = new Function<YarnTwillController, TwillController>(){

        public TwillController apply(YarnTwillController controller) {
            return controller;
        }
    };
    private final YarnConfiguration yarnConfig;
    private final ZKClientService zkClientService;
    private final LocationFactory locationFactory;
    private final Table<String, RunId, YarnTwillController> controllers;
    private final Service serviceDelegate;
    private LocationCache locationCache;
    private LocationCacheCleaner locationCacheCleaner;
    private ScheduledExecutorService secureStoreScheduler;
    private Iterable<TwillRunner.LiveInfo> liveInfos;
    private Cancellable watchCancellable;
    private volatile String jvmOptions = null;

    public YarnTwillRunnerService(YarnConfiguration config, String zkConnect) {
        this(config, zkConnect, YarnTwillRunnerService.createDefaultLocationFactory((Configuration)config));
    }

    public YarnTwillRunnerService(YarnConfiguration config, String zkConnect, LocationFactory locationFactory) {
        this.yarnConfig = config;
        this.locationFactory = locationFactory;
        this.zkClientService = this.getZKClientService(zkConnect);
        this.controllers = HashBasedTable.create();
        this.serviceDelegate = new AbstractIdleService(){

            protected void startUp() throws Exception {
                YarnTwillRunnerService.this.startUp();
            }

            protected void shutDown() throws Exception {
                YarnTwillRunnerService.this.shutDown();
            }
        };
    }

    public void start() {
        this.serviceDelegate.startAndWait();
    }

    public void stop() {
        this.serviceDelegate.stopAndWait();
    }

    public void setJVMOptions(String options) {
        Preconditions.checkArgument((options != null ? 1 : 0) != 0, (Object)"JVM options cannot be null.");
        this.jvmOptions = options;
    }

    public String getJVMOptions() {
        return this.jvmOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cancellable scheduleSecureStoreUpdate(final SecureStoreUpdater updater, long initialDelay, long delay, TimeUnit unit) {
        YarnTwillRunnerService yarnTwillRunnerService = this;
        synchronized (yarnTwillRunnerService) {
            if (this.secureStoreScheduler == null) {
                this.secureStoreScheduler = Executors.newSingleThreadScheduledExecutor(Threads.createDaemonThreadFactory((String)"secure-store-renewer"));
            }
        }
        final ScheduledFuture<?> future = this.secureStoreScheduler.scheduleWithFixedDelay(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashBasedTable liveApps;
                4 var2_1 = this;
                synchronized (var2_1) {
                    liveApps = HashBasedTable.create((Table)YarnTwillRunnerService.this.controllers);
                }
                YarnTwillRunnerService.this.renewSecureStore((Table<String, RunId, YarnTwillController>)((Table)liveApps), new SecureStoreRenewer(){

                    public void renew(String application, RunId runId, SecureStoreWriter secureStoreWriter) throws IOException {
                        secureStoreWriter.write(updater.update(application, runId));
                    }
                }, true);
            }
        }, initialDelay, delay, unit);
        return new Cancellable(){

            public void cancel() {
                future.cancel(false);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cancellable setSecureStoreRenewer(SecureStoreRenewer renewer, long initialDelay, long delay, long retryDelay, TimeUnit unit) {
        YarnTwillRunnerService yarnTwillRunnerService = this;
        synchronized (yarnTwillRunnerService) {
            if (this.secureStoreScheduler != null) {
                this.stopScheduler(this.secureStoreScheduler);
            }
            this.secureStoreScheduler = Executors.newSingleThreadScheduledExecutor(Threads.createDaemonThreadFactory((String)"secure-store-renewer"));
        }
        final ScheduledExecutorService currentScheduler = this.secureStoreScheduler;
        this.secureStoreScheduler.scheduleWithFixedDelay(this.createSecureStoreUpdateRunnable(currentScheduler, renewer, (Multimap<String, RunId>)ImmutableMultimap.of(), retryDelay, unit), initialDelay, delay, unit);
        return new Cancellable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void cancel() {
                YarnTwillRunnerService yarnTwillRunnerService = YarnTwillRunnerService.this;
                synchronized (yarnTwillRunnerService) {
                    if (currentScheduler == YarnTwillRunnerService.this.secureStoreScheduler) {
                        YarnTwillRunnerService.this.secureStoreScheduler.shutdown();
                        YarnTwillRunnerService.this.secureStoreScheduler = null;
                    }
                }
            }
        };
    }

    public TwillPreparer prepare(TwillRunnable runnable) {
        return this.prepare(runnable, ResourceSpecification.BASIC);
    }

    public TwillPreparer prepare(TwillRunnable runnable, ResourceSpecification resourceSpecification) {
        return this.prepare((TwillApplication)new SingleRunnableApplication(runnable, resourceSpecification));
    }

    public TwillPreparer prepare(TwillApplication application) {
        Preconditions.checkState((boolean)this.serviceDelegate.isRunning(), (Object)"Service not start. Please call start() first.");
        TwillSpecification twillSpec = application.configure();
        final String appName = twillSpec.getName();
        RunId runId = RunIds.generate();
        Location appLocation = this.locationFactory.create(String.format("/%s/%s", twillSpec.getName(), runId.getId()));
        LocationCache locationCache = this.locationCache;
        if (locationCache == null) {
            locationCache = new NoCachingLocationCache(appLocation);
        }
        Configuration config = new Configuration((Configuration)this.yarnConfig);
        return new YarnTwillPreparer(config, twillSpec, runId, this.zkClientService.getConnectString(), appLocation, this.jvmOptions, locationCache, new YarnTwillControllerFactory(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public YarnTwillController create(RunId runId, boolean logCollectionEnabled, Iterable<LogHandler> logHandlers, Callable<ProcessController<YarnApplicationReport>> startUp, long startTimeout, TimeUnit startTimeoutUnit) {
                ZKClient zkClient = ZKClients.namespace((ZKClient)YarnTwillRunnerService.this.zkClientService, (String)("/" + appName));
                YarnTwillController controller = YarnTwillRunnerService.this.listenController(new YarnTwillController(appName, runId, zkClient, logCollectionEnabled, logHandlers, startUp, startTimeout, startTimeoutUnit));
                YarnTwillRunnerService yarnTwillRunnerService = YarnTwillRunnerService.this;
                synchronized (yarnTwillRunnerService) {
                    Preconditions.checkArgument((!YarnTwillRunnerService.this.controllers.contains((Object)appName, (Object)runId) ? 1 : 0) != 0, (String)"Application %s with runId %s is already running.", (Object[])new Object[]{appName, runId});
                    YarnTwillRunnerService.this.controllers.put((Object)appName, (Object)runId, (Object)controller);
                }
                return controller;
            }
        });
    }

    public synchronized TwillController lookup(String applicationName, RunId runId) {
        return (TwillController)this.controllers.get((Object)applicationName, (Object)runId);
    }

    public Iterable<TwillController> lookup(final String applicationName) {
        return new Iterable<TwillController>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Iterator<TwillController> iterator() {
                YarnTwillRunnerService yarnTwillRunnerService = YarnTwillRunnerService.this;
                synchronized (yarnTwillRunnerService) {
                    return Iterators.transform((Iterator)ImmutableList.copyOf(YarnTwillRunnerService.this.controllers.row((Object)applicationName).values()).iterator(), (Function)CAST_CONTROLLER);
                }
            }
        };
    }

    public Iterable<TwillRunner.LiveInfo> lookupLive() {
        return this.liveInfos;
    }

    private void startUp() throws Exception {
        String cacheDir;
        this.zkClientService.startAndWait();
        ZKOperations.ignoreError((OperationFuture)this.zkClientService.create("/", null, CreateMode.PERSISTENT), KeeperException.NodeExistsException.class, null).get();
        this.watchCancellable = this.watchLiveApps();
        this.liveInfos = this.createLiveInfos();
        boolean enableSecureStoreUpdate = this.yarnConfig.getBoolean("twill.secure.store.update.location.enabled", true);
        if (UserGroupInformation.isSecurityEnabled() && enableSecureStoreUpdate) {
            long renewalInterval = this.yarnConfig.getLong("dfs.namenode.delegation.token.renew-interval", 86400000L);
            long delay = renewalInterval - TimeUnit.MINUTES.toMillis(5L);
            if (delay <= 0L) {
                delay = renewalInterval <= 2L ? 1L : renewalInterval / 2L;
            }
            this.setSecureStoreRenewer(new LocationSecureStoreRenewer((Configuration)this.yarnConfig, this.locationFactory), delay, delay, 10000L, TimeUnit.MILLISECONDS);
        }
        if ((cacheDir = this.yarnConfig.get("twill.location.cache.dir")) != null) {
            String sessionId = Long.toString(System.currentTimeMillis());
            try {
                Location cacheBase = this.locationFactory.create(cacheDir);
                cacheBase.mkdirs();
                cacheBase.setPermissions("775");
                Location cacheLocation = cacheBase.append(sessionId);
                cacheLocation.mkdirs();
                cacheLocation.setPermissions("775");
                this.locationCache = new BasicLocationCache(cacheLocation);
                this.locationCacheCleaner = this.startLocationCacheCleaner(cacheBase, sessionId);
            }
            catch (IOException e) {
                LOG.warn("Failed to create location cache directory. Location cache cannot be enabled.", (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    void forceLocationCacheCleanup(long currentTime) {
        this.locationCacheCleaner.forceCleanup(currentTime);
    }

    private LocationCacheCleaner startLocationCacheCleaner(Location cacheBase, String sessionId) {
        LocationCacheCleaner cleaner = new LocationCacheCleaner((Configuration)this.yarnConfig, cacheBase, sessionId, location -> {
            HashSet<Location> activeLocations = new HashSet<Location>();
            YarnTwillRunnerService yarnTwillRunnerService = this;
            synchronized (yarnTwillRunnerService) {
                for (YarnTwillController controller : this.controllers.values()) {
                    ApplicationMasterLiveNodeData amLiveNodeData = controller.getApplicationMasterLiveNodeData();
                    if (amLiveNodeData == null) continue;
                    for (LocalFile localFile : amLiveNodeData.getLocalFiles()) {
                        activeLocations.add(this.locationFactory.create(localFile.getURI()));
                    }
                }
            }
            try {
                activeLocations.add(cacheBase.append(sessionId).append("launcher.jar"));
                activeLocations.add(cacheBase.append(sessionId).append("twill.jar"));
            }
            catch (IOException e) {
                LOG.warn("Failed to construct cache location", (Throwable)e);
            }
            return !activeLocations.contains(location);
        });
        cleaner.startAndWait();
        return cleaner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutDown() throws Exception {
        YarnTwillRunnerService yarnTwillRunnerService = this;
        synchronized (yarnTwillRunnerService) {
            if (this.locationCacheCleaner != null) {
                this.locationCacheCleaner.stopAndWait();
            }
            if (this.secureStoreScheduler != null) {
                this.secureStoreScheduler.shutdownNow();
            }
        }
        this.watchCancellable.cancel();
        this.zkClientService.stopAndWait();
    }

    private Cancellable watchLiveApps() {
        final ConcurrentMap watched = Maps.newConcurrentMap();
        final AtomicBoolean cancelled = new AtomicBoolean(false);
        final Cancellable cancellable = ZKOperations.watchChildren((ZKClient)this.zkClientService, (String)"/", (ZKOperations.ChildrenCallback)new ZKOperations.ChildrenCallback(){

            public void updated(NodeChildren nodeChildren) {
                if (cancelled.get()) {
                    return;
                }
                ImmutableSet apps = ImmutableSet.copyOf((Collection)nodeChildren.getChildren());
                for (final String appName : apps) {
                    if (watched.containsKey(appName)) continue;
                    String instancePath = String.format("/%s/instances", appName);
                    watched.put(appName, ZKOperations.watchChildren((ZKClient)YarnTwillRunnerService.this.zkClientService, (String)instancePath, (ZKOperations.ChildrenCallback)new ZKOperations.ChildrenCallback(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void updated(NodeChildren nodeChildren) {
                            if (cancelled.get()) {
                                return;
                            }
                            if (nodeChildren.getChildren().isEmpty()) {
                                Cancellable removed = (Cancellable)watched.remove(appName);
                                if (removed != null) {
                                    removed.cancel();
                                }
                                return;
                            }
                            YarnTwillRunnerService yarnTwillRunnerService = YarnTwillRunnerService.this;
                            synchronized (yarnTwillRunnerService) {
                                for (RunId runId : Iterables.transform((Iterable)nodeChildren.getChildren(), (Function)STRING_TO_RUN_ID)) {
                                    if (YarnTwillRunnerService.this.controllers.contains((Object)appName, (Object)runId)) continue;
                                    YarnTwillRunnerService.this.updateController(appName, runId, cancelled);
                                }
                            }
                        }
                    }));
                }
                for (String removeApp : Sets.difference(watched.keySet(), (Set)apps)) {
                    ((Cancellable)watched.remove(removeApp)).cancel();
                }
            }
        });
        return new Cancellable(){

            public void cancel() {
                cancelled.set(true);
                cancellable.cancel();
                for (Cancellable c : watched.values()) {
                    c.cancel();
                }
            }
        };
    }

    private YarnTwillController listenController(final YarnTwillController controller) {
        controller.onTerminated(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                YarnTwillRunnerService yarnTwillRunnerService = YarnTwillRunnerService.this;
                synchronized (yarnTwillRunnerService) {
                    Iterables.removeIf((Iterable)YarnTwillRunnerService.this.controllers.values(), (Predicate)new Predicate<YarnTwillController>(){

                        public boolean apply(YarnTwillController input) {
                            return input == controller;
                        }
                    });
                }
            }
        }, Threads.SAME_THREAD_EXECUTOR);
        return controller;
    }

    private ZKClientService getZKClientService(String zkConnect) {
        return ZKClientServices.delegate((ZKClient)ZKClients.reWatchOnExpire((ZKClient)ZKClients.retryOnFailure((ZKClient)ZKClientService.Builder.of((String)zkConnect).setSessionTimeout(10000).build(), (RetryStrategy)RetryStrategies.exponentialDelay((long)100L, (long)2000L, (TimeUnit)TimeUnit.MILLISECONDS))));
    }

    private Iterable<TwillRunner.LiveInfo> createLiveInfos() {
        return new Iterable<TwillRunner.LiveInfo>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Iterator<TwillRunner.LiveInfo> iterator() {
                ImmutableMap controllerMap;
                YarnTwillRunnerService yarnTwillRunnerService = YarnTwillRunnerService.this;
                synchronized (yarnTwillRunnerService) {
                    controllerMap = ImmutableTable.copyOf((Table)YarnTwillRunnerService.this.controllers).rowMap();
                }
                return Iterators.transform(controllerMap.entrySet().iterator(), (Function)new Function<Map.Entry<String, Map<RunId, YarnTwillController>>, TwillRunner.LiveInfo>(){

                    public TwillRunner.LiveInfo apply(final Map.Entry<String, Map<RunId, YarnTwillController>> entry) {
                        return new TwillRunner.LiveInfo(){

                            public String getApplicationName() {
                                return (String)entry.getKey();
                            }

                            public Iterable<TwillController> getControllers() {
                                return Iterables.transform(((Map)entry.getValue()).values(), (Function)CAST_CONTROLLER);
                            }
                        };
                    }
                });
            }
        };
    }

    private void updateController(final String appName, final RunId runId, final AtomicBoolean cancelled) {
        String instancePath = String.format("/%s/instances/%s", appName, runId.getId());
        Futures.addCallback((ListenableFuture)this.zkClientService.getData(instancePath), (FutureCallback)new FutureCallback<NodeData>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(NodeData result) {
                if (cancelled.get()) {
                    return;
                }
                ApplicationMasterLiveNodeData amLiveNodeData = ApplicationMasterLiveNodeDecoder.decode(result);
                if (amLiveNodeData == null) {
                    return;
                }
                YarnTwillRunnerService yarnTwillRunnerService = YarnTwillRunnerService.this;
                synchronized (yarnTwillRunnerService) {
                    if (!YarnTwillRunnerService.this.controllers.contains((Object)appName, (Object)runId)) {
                        ZKClient zkClient = ZKClients.namespace((ZKClient)YarnTwillRunnerService.this.zkClientService, (String)("/" + appName));
                        YarnAppClient yarnAppClient = new VersionDetectYarnAppClientFactory().create(new Configuration((Configuration)YarnTwillRunnerService.this.yarnConfig));
                        YarnTwillController controller = YarnTwillRunnerService.this.listenController(new YarnTwillController(appName, runId, zkClient, amLiveNodeData, yarnAppClient));
                        YarnTwillRunnerService.this.controllers.put((Object)appName, (Object)runId, (Object)controller);
                        controller.start();
                    }
                }
            }

            public void onFailure(Throwable t) {
                LOG.warn("Failed in fetching application instance node.", t);
            }
        }, (Executor)Threads.SAME_THREAD_EXECUTOR);
    }

    private void stopScheduler(ScheduledExecutorService scheduler) {
        scheduler.shutdown();
        boolean interrupted = false;
        while (true) {
            try {
                scheduler.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
                return;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private Runnable createSecureStoreUpdateRunnable(final ScheduledExecutorService scheduler, final SecureStoreRenewer renewer, final Multimap<String, RunId> retryRuns, final long retryDelay, final TimeUnit timeUnit) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashBasedTable liveApps;
                YarnTwillRunnerService yarnTwillRunnerService = YarnTwillRunnerService.this;
                synchronized (yarnTwillRunnerService) {
                    if (retryRuns.isEmpty()) {
                        liveApps = HashBasedTable.create((Table)YarnTwillRunnerService.this.controllers);
                    } else {
                        liveApps = HashBasedTable.create();
                        for (Table.Cell cell : YarnTwillRunnerService.this.controllers.cellSet()) {
                            if (!retryRuns.containsEntry(cell.getRowKey(), cell.getColumnKey())) continue;
                            liveApps.put(cell.getRowKey(), cell.getColumnKey(), cell.getValue());
                        }
                    }
                }
                Multimap failureRenews = YarnTwillRunnerService.this.renewSecureStore((Table<String, RunId, YarnTwillController>)((Table)liveApps), renewer, false);
                if (!failureRenews.isEmpty()) {
                    LOG.info("Schedule to retry on secure store renewal for applications {} in {} {}", new Object[]{failureRenews.keySet(), retryDelay, timeUnit.name().toLowerCase()});
                    try {
                        scheduler.schedule(YarnTwillRunnerService.this.createSecureStoreUpdateRunnable(scheduler, renewer, (Multimap<String, RunId>)failureRenews, retryDelay, timeUnit), retryDelay, timeUnit);
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    private Multimap<String, RunId> renewSecureStore(Table<String, RunId, YarnTwillController> liveApps, SecureStoreRenewer renewer, boolean mergeCredentials) {
        HashMultimap failureRenews = HashMultimap.create();
        for (Table.Cell liveApp : liveApps.cellSet()) {
            String application = (String)liveApp.getRowKey();
            RunId runId = (RunId)liveApp.getColumnKey();
            YarnTwillController controller = (YarnTwillController)((Object)liveApp.getValue());
            try {
                renewer.renew(application, runId, (SecureStoreWriter)new YarnSecureStoreWriter(application, runId, controller, mergeCredentials));
            }
            catch (Exception e) {
                LOG.warn("Failed to renew secure store for {}:{}", new Object[]{application, runId, e});
                failureRenews.put((Object)application, (Object)runId);
            }
        }
        return failureRenews;
    }

    private static LocationFactory createDefaultLocationFactory(Configuration configuration) {
        try {
            FileContext fc = FileContext.getFileContext((Configuration)configuration);
            String basePath = fc.getHomeDirectory().toUri().getPath();
            return new FileContextLocationFactory(configuration, basePath);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private final class YarnSecureStoreWriter
    implements SecureStoreWriter {
        private final String application;
        private final RunId runId;
        private final YarnTwillController controller;
        private final boolean mergeCredentials;

        private YarnSecureStoreWriter(String application, RunId runId, YarnTwillController controller, boolean mergeCredentials) {
            this.application = application;
            this.runId = runId;
            this.controller = controller;
            this.mergeCredentials = mergeCredentials;
        }

        public void write(SecureStore secureStore) throws IOException {
            Object store = secureStore.getStore();
            if (!(store instanceof Credentials)) {
                LOG.warn("Only Hadoop Credentials is supported. Ignore update for {}:{} with secure store {}", new Object[]{this.application, this.runId, secureStore});
                return;
            }
            Location credentialsLocation = YarnTwillRunnerService.this.locationFactory.create(String.format("/%s/%s/%s", this.application, this.runId.getId(), "credentials.store"));
            LOG.debug("Writing new secure store for {}:{} to {}", new Object[]{this.application, this.runId, credentialsLocation});
            Credentials credentials = new Credentials();
            if (this.mergeCredentials) {
                try (DataInputStream is2 = new DataInputStream(new BufferedInputStream(credentialsLocation.getInputStream()));){
                    credentials.readTokenStorageStream(is2);
                }
                catch (FileNotFoundException is2) {
                }
                catch (Exception e) {
                    LOG.warn("Failed to read existing credentials from {} for merging due to {}.", (Object)credentialsLocation, (Object)e.toString());
                }
            }
            credentials.addAll((Credentials)store);
            Location tmpLocation = credentialsLocation.getTempFile("credentials.store");
            try (DataOutputStream os = new DataOutputStream(new BufferedOutputStream(tmpLocation.getOutputStream("600")));){
                credentials.writeTokenStorageToStream(os);
            }
            tmpLocation.renameTo(credentialsLocation);
            this.controller.secureStoreUpdated();
            LOG.debug("Secure store for {} {} saved to {}.", new Object[]{this.application, this.runId, credentialsLocation});
        }
    }
}

