/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.actuator.util;

import com.fasterxml.jackson.databind.JsonNode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;

public class MicroServiceInitData {
    private static final String DEL_COLUMN_NAME = "$DEL";

    public static void processInitData(JsonNode data, Connection connection, Set<String> tables) throws SQLException {
        Iterator tableNames = data.fieldNames();
        while (tableNames.hasNext()) {
            String tableName = (String)tableNames.next();
            if (!tables.contains(tableName)) continue;
            MicroServiceInitData.processTableData(data.get(tableName), tableName, connection);
        }
    }

    private static void processTableData(JsonNode data, String tableName, Connection connection) throws SQLException {
        if (data.size() == 0) {
            return;
        }
        TableDescription description = MicroServiceInitData.makeTableDescription(data.get(0), tableName);
        for (int i = 0; i < data.size(); ++i) {
            MicroServiceInitData.processRowData(data.get(i), tableName, connection, description);
        }
    }

    private static void processRowData(JsonNode data, String tableName, Connection connection, TableDescription description) throws SQLException {
        Object keyData = MicroServiceInitData.queryPrimaryKeyByUnique(data, tableName, connection, description);
        if (data.get(DEL_COLUMN_NAME) == null || data.get(DEL_COLUMN_NAME).asInt() != 1) {
            if (keyData == null) {
                MicroServiceInitData.insertRowData(data, tableName, connection, description);
                keyData = MicroServiceInitData.queryPrimaryKeyByUnique(data, tableName, connection, description);
            } else {
                MicroServiceInitData.updateRowData(data, tableName, connection, description, keyData);
            }
            if (!description.multiLanguageColumns.isEmpty()) {
                MicroServiceInitData.processRowMultiLanguage(data, tableName, connection, description, keyData);
            }
        } else if (keyData != null) {
            MicroServiceInitData.deleteRowData(tableName, connection, description, keyData);
            MicroServiceInitData.deleteRowMultiLanguage(tableName, connection, description, keyData);
        }
    }

    private static void deleteRowData(String tableName, Connection connection, TableDescription description, Object keyData) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ");
        sql.append(tableName);
        sql.append(" WHERE ");
        sql.append(description.primaryKey);
        sql.append("=?");
        try (PreparedStatement statement = connection.prepareStatement(sql.toString());){
            statement.setObject(1, keyData);
            if (statement.executeUpdate() != 1) {
                throw new IllegalStateException("Execute update result not one.");
            }
        }
    }

    private static void deleteRowMultiLanguage(String tableName, Connection connection, TableDescription description, Object keyData) throws SQLException {
        String upperCaseTableName = tableName.toUpperCase();
        String multiLanguageTableName = upperCaseTableName + "_TL";
        if (upperCaseTableName.endsWith("_B")) {
            multiLanguageTableName = upperCaseTableName.substring(0, upperCaseTableName.length() - 2) + "_TL";
        }
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ");
        sql.append(multiLanguageTableName);
        sql.append(" WHERE ");
        sql.append(description.primaryKey);
        sql.append("=?");
        try (PreparedStatement statement = connection.prepareStatement(sql.toString());){
            statement.setObject(1, keyData);
        }
    }

    private static void processRowMultiLanguage(JsonNode data, String tableName, Connection connection, TableDescription description, Object keyData) throws SQLException {
        String upperCaseTableName = tableName.toUpperCase();
        String multiLanguageTableName = upperCaseTableName + "_TL";
        if (upperCaseTableName.endsWith("_B")) {
            multiLanguageTableName = upperCaseTableName.substring(0, upperCaseTableName.length() - 2) + "_TL";
        }
        for (String language : description.multiLanguages) {
            if (MicroServiceInitData.checkExitsMultiLanguageRecord(data, multiLanguageTableName, connection, description, keyData, language)) {
                MicroServiceInitData.updateRowMultiLanguage(data, multiLanguageTableName, connection, description, keyData, language);
                continue;
            }
            MicroServiceInitData.insertRowMultiLanguage(data, multiLanguageTableName, connection, description, keyData, language);
        }
    }

    private static void updateRowMultiLanguage(JsonNode data, String tableName, Connection connection, TableDescription description, Object keyData, String language) throws SQLException {
        ArrayList<JsonNode> updateParameters = new ArrayList<JsonNode>();
        StringJoiner updateColumnsJoiner = new StringJoiner(",");
        for (String column : description.multiLanguageColumns) {
            updateColumnsJoiner.add(column + "=?");
            updateParameters.add(data.get(column + ":" + language));
        }
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ");
        sql.append(tableName);
        sql.append(" SET ");
        sql.append(updateColumnsJoiner.toString());
        sql.append(" WHERE ");
        sql.append(description.primaryKey);
        sql.append("=? AND LANG=?");
        try (PreparedStatement statement = connection.prepareStatement(sql.toString());){
            for (int updateParameterIndex = 0; updateParameterIndex < updateParameters.size(); ++updateParameterIndex) {
                MicroServiceInitData.setNodeValue((JsonNode)updateParameters.get(updateParameterIndex), statement, updateParameterIndex + 1);
            }
            statement.setObject(updateParameters.size() + 1, keyData);
            statement.setString(updateParameters.size() + 2, language);
            if (statement.executeUpdate() != 1) {
                throw new IllegalStateException("Execute update result not one.");
            }
        }
    }

    private static void insertRowMultiLanguage(JsonNode data, String tableName, Connection connection, TableDescription description, Object keyData, String language) throws SQLException {
        ArrayList<JsonNode> insertParameters = new ArrayList<JsonNode>();
        StringJoiner insertColumnsJoiner = new StringJoiner(",");
        StringJoiner insertParametersJoiner = new StringJoiner(",");
        for (String column : description.multiLanguageColumns) {
            insertColumnsJoiner.add(column);
            insertParametersJoiner.add("?");
            insertParameters.add(data.get(column + ":" + language));
        }
        insertColumnsJoiner.add(description.primaryKey);
        insertParametersJoiner.add("?");
        insertColumnsJoiner.add("LANG");
        insertParametersJoiner.add("?");
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ");
        sql.append(tableName);
        sql.append(" ( ");
        sql.append(insertColumnsJoiner.toString());
        sql.append(" ) VALUES ( ");
        sql.append(insertParametersJoiner.toString());
        sql.append(" )");
        try (PreparedStatement statement = connection.prepareStatement(sql.toString());){
            for (int insertParameterIndex = 0; insertParameterIndex < insertParameters.size(); ++insertParameterIndex) {
                MicroServiceInitData.setNodeValue((JsonNode)insertParameters.get(insertParameterIndex), statement, insertParameterIndex + 1);
            }
            statement.setObject(insertParameters.size() + 1, keyData);
            statement.setString(insertParameters.size() + 2, language);
            if (statement.executeUpdate() != 1) {
                throw new IllegalStateException("Execute update result not one.");
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static boolean checkExitsMultiLanguageRecord(JsonNode data, String tableName, Connection connection, TableDescription description, Object keyData, String language) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void updateRowData(JsonNode data, String tableName, Connection connection, TableDescription description, Object keyData) throws SQLException {
        ArrayList<JsonNode> updateParameters = new ArrayList<JsonNode>();
        StringJoiner updateColumnsJoiner = new StringJoiner(",");
        for (String uniqueKey : description.uniqueKeys) {
            updateColumnsJoiner.add(uniqueKey + "=?");
            updateParameters.add(data.get(description.rawColumns.get(uniqueKey)));
        }
        for (String column : description.updateColumns) {
            updateColumnsJoiner.add(column + "=?");
            updateParameters.add(data.get(description.rawColumns.get(column)));
        }
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ");
        sql.append(tableName);
        sql.append(" SET ");
        sql.append(updateColumnsJoiner.toString());
        sql.append(" WHERE ");
        sql.append(description.primaryKey);
        sql.append("=?");
        try (PreparedStatement statement = connection.prepareStatement(sql.toString());){
            for (int updateParameterIndex = 0; updateParameterIndex < updateParameters.size(); ++updateParameterIndex) {
                MicroServiceInitData.setNodeValue((JsonNode)updateParameters.get(updateParameterIndex), statement, updateParameterIndex + 1);
            }
            statement.setObject(updateParameters.size() + 1, keyData);
            if (statement.executeUpdate() != 1) {
                throw new IllegalStateException("Execute update result not one.");
            }
        }
    }

    private static void insertRowData(JsonNode data, String tableName, Connection connection, TableDescription description) throws SQLException {
        ArrayList<JsonNode> insertParameters = new ArrayList<JsonNode>();
        StringJoiner insertColumnsJoiner = new StringJoiner(",");
        StringJoiner insertParametersJoiner = new StringJoiner(",");
        for (String uniqueKey : description.uniqueKeys) {
            insertColumnsJoiner.add(uniqueKey);
            insertParametersJoiner.add("?");
            insertParameters.add(data.get(description.rawColumns.get(uniqueKey)));
        }
        for (String column : description.insertColumns) {
            insertColumnsJoiner.add(column);
            insertParametersJoiner.add("?");
            JsonNode param = data.get(description.rawColumns.get(column));
            insertParameters.add(param);
        }
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ");
        sql.append(tableName);
        sql.append(" ( ");
        sql.append(insertColumnsJoiner.toString());
        sql.append(" ) VALUES ( ");
        sql.append(insertParametersJoiner.toString());
        sql.append(" )");
        try (PreparedStatement statement = connection.prepareStatement(sql.toString());){
            for (int insertParameterIndex = 0; insertParameterIndex < insertParameters.size(); ++insertParameterIndex) {
                MicroServiceInitData.setNodeValue((JsonNode)insertParameters.get(insertParameterIndex), statement, insertParameterIndex + 1);
            }
            if (statement.executeUpdate() != 1) {
                throw new IllegalStateException("Execute update result not one.");
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static Object queryPrimaryKeyByUnique(JsonNode data, String tableName, Connection connection, TableDescription description) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void setNodeValue(JsonNode data, PreparedStatement statement, int i) throws SQLException {
        switch (data.getNodeType()) {
            case NUMBER: {
                statement.setLong(i, data.longValue());
                break;
            }
            case BOOLEAN: {
                statement.setBoolean(i, data.booleanValue());
                break;
            }
            case NULL: {
                statement.setObject(i, null);
                break;
            }
            default: {
                statement.setString(i, data.asText());
            }
        }
    }

    private static TableDescription makeTableDescription(JsonNode header, String tableName) {
        TableDescription description = new TableDescription();
        Iterator columnNames = header.fieldNames();
        while (columnNames.hasNext()) {
            String columnName = (String)columnNames.next();
            if (DEL_COLUMN_NAME.equals(columnName)) continue;
            if (columnName.startsWith("*")) {
                if (description.primaryKey != null) {
                    throw new IllegalStateException("Multi-primary key not supported in table: " + tableName);
                }
                description.primaryKey = columnName.substring(1);
                description.rawColumns.put(description.primaryKey, columnName);
                continue;
            }
            if (columnName.startsWith("#")) {
                description.uniqueKeys.add(columnName.substring(1));
                description.rawColumns.put(columnName.substring(1), columnName);
                continue;
            }
            if (columnName.contains(":")) {
                String[] columnSplit = columnName.split(":");
                if (columnSplit.length != 2) {
                    throw new IllegalStateException("Multi-languages column format error in table: " + tableName);
                }
                description.multiLanguages.add(columnSplit[1]);
                description.multiLanguageColumns.add(columnSplit[0]);
                continue;
            }
            if (columnName.startsWith("@") || columnName.startsWith("$")) {
                description.insertColumns.add(columnName.substring(1));
                description.rawColumns.put(columnName.substring(1), columnName);
                continue;
            }
            description.updateColumns.add(columnName);
            description.insertColumns.add(columnName);
            description.rawColumns.put(columnName, columnName);
        }
        if (description.primaryKey == null) {
            throw new IllegalStateException("Must have a primary key in table: " + tableName);
        }
        if (description.uniqueKeys.isEmpty()) {
            throw new IllegalStateException("Must have at least one unique key in table: " + tableName);
        }
        return description;
    }

    private static class TableDescription {
        String primaryKey = null;
        Set<String> uniqueKeys = new TreeSet<String>();
        Map<String, String> rawColumns = new HashMap<String, String>();
        Set<String> insertColumns = new TreeSet<String>();
        Set<String> updateColumns = new TreeSet<String>();
        Set<String> multiLanguageColumns = new TreeSet<String>();
        Set<String> multiLanguages = new TreeSet<String>();

        private TableDescription() {
        }
    }
}

