/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.base.enums;

public enum ProjectCategory {
    AGILE("agile"),
    PROGRAM("program"),
    ANALYTICAL("analytical");

    private String value;

    private ProjectCategory(String value) {
        this.value = value;
    }

    public String value() {
        return this.value;
    }

    public static boolean contains(String value) {
        for (ProjectCategory projectCategory : ProjectCategory.values()) {
            if (!projectCategory.value.equals(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAgile(String value) {
        return ProjectCategory.AGILE.value.equals(value);
    }

    public static boolean isProgram(String value) {
        return ProjectCategory.PROGRAM.value.equals(value);
    }

    public static boolean isAnalytical(String value) {
        return ProjectCategory.ANALYTICAL.value.equals(value);
    }
}

