/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.base.enums;

public enum ResourceType {
    SITE("site"),
    ORGANIZATION("organization"),
    PROJECT("project");

    private String value;

    private ResourceType(String value) {
        this.value = value;
    }

    public String value() {
        return this.value;
    }

    public static boolean contains(String value) {
        for (ResourceType resourceType : ResourceType.values()) {
            if (!resourceType.value.equals(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSite(String value) {
        return ResourceType.SITE.value.equals(value);
    }

    public static boolean isOrganization(String value) {
        return ResourceType.ORGANIZATION.value.equals(value);
    }

    public static boolean isProject(String value) {
        return ResourceType.PROJECT.value.equals(value);
    }
}

