/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.fragment.service.impl;

import io.choerodon.core.convertor.ApplicationContextHelper;
import io.choerodon.core.exception.CommonException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.hzero.core.util.Pair;
import org.hzero.fragment.config.FragmentConfig;
import org.hzero.fragment.service.FileHandler;
import org.hzero.fragment.service.FragmentService;
import org.hzero.fragment.service.impl.FragmentServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FragmentC7nServiceImpl
extends FragmentServiceImpl
implements FragmentService {
    private static final Logger logger = LoggerFactory.getLogger(FragmentC7nServiceImpl.class);
    @Autowired
    private FragmentConfig fragmentConfig;

    public String combineUpload(String guid, Long tenantId, String filename, Map<String, String> params) {
        if (params == null) {
            params = new HashMap<String, String>(1);
        }
        Pair pair = this.combineBlock(guid, filename);
        String filePath = (String)pair.getFirst();
        String tempDtr = (String)pair.getSecond();
        try {
            Map map = ApplicationContextHelper.getContext().getBeansOfType(FileHandler.class);
            String url = null;
            if (!map.isEmpty()) {
                for (FileHandler handler : map.values()) {
                    url = handler.process(tenantId, filename, filePath, (InputStream)new FileInputStream(new File(filePath)), params);
                }
            }
            this.deleteFile(new File(tempDtr));
            this.deleteFile(new File(filePath));
            return url;
        }
        catch (IOException e) {
            logger.error("exception:", (Throwable)e);
            this.deleteFile(new File(filePath));
            return null;
        }
        catch (CommonException e) {
            logger.error("exception:", (Throwable)e);
            this.deleteFile(new File(filePath));
            this.deleteFile(new File(tempDtr));
            throw e;
        }
        catch (Exception e) {
            logger.error("exception:", (Throwable)e);
            this.deleteFile(new File(filePath));
            throw e;
        }
    }

    public void upload(MultipartFile file, Integer chunk, String guid) {
        try (InputStream inputStream = file.getInputStream();){
            if (chunk == null) {
                chunk = 0;
            }
            String filePath = this.getRootPath() + File.separator + "temp" + File.separator + guid + File.separator + chunk;
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)new File(filePath));
        }
        catch (Exception e) {
            throw new CommonException("error.error", (Throwable)e);
        }
    }

    private String getRootPath() {
        String rootPath = this.fragmentConfig.getRootPath();
        if (StringUtils.isBlank((CharSequence)rootPath)) {
            return ROOT;
        }
        return rootPath;
    }

    private void deleteFile(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files == null) {
                return;
            }
            for (File f : files) {
                this.deleteFile(f);
            }
        }
        file.delete();
    }
}

