package io.choerodon.scheduler.helper;

import io.choerodon.core.exception.CommonException;
import io.choerodon.scheduler.helper.client.JobClient;
import io.choerodon.scheduler.helper.domain.JobInfo;

/**
 * 根据已有的计划任务对象，判断合法性并创建计划任务
 *
 * @author wuguokai
 */
public class SchedulerTemplate {
    private JobClient jobClient;

    public SchedulerTemplate(JobClient jobClient) {
        this.jobClient = jobClient;
    }

    /**
     * {@inheritDoc}
     *
     * @param job 计划任务对象
     * @return
     */
    public JobInfo createJob(JobInfo job) {
        if (job == null) {
            throw new CommonException("job信息不存在");
        }
        if (job.getJobDescription() == null || job.getJobDescription().isEmpty()) {
            throw new IllegalStateException("job描述缺失");
        }
        if (job.getTriggerType() == null) {
            throw new IllegalStateException("job类型缺失");
        }
        if (job.getTriggerType().equals("CRON")
                && (job.getCronExpression() == null || job.getCronExpression().isEmpty())) {
            throw new IllegalStateException("job类型为CRON时，cron表达式不能为空");
        }
        if (job.getRequestService() == null || job.getRequestService().isEmpty()) {
            throw new IllegalStateException("job请求服务不能为空");
        }
        if (job.getRequestMethod() == null || job.getRequestService().isEmpty()) {
            throw new IllegalStateException("job请求方法不能为空");
        }
        if (job.getRequestUrl() == null) {
            throw new IllegalStateException("job请求url不能为空");
        }
        return jobClient.createJob(job);
    }
}
