package io.choerodon.scheduler.helper.domain;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * 计划任务信息对象，向scheduler-service服务发送请求时携带的参数
 *
 * @author wuguokai
 */
public class JobInfo {
    private Long id;

    private String jobGroup;

    private String triggerType;

    private String triggerState;

    private String jobDescription;

    private Integer priority;

    @JsonIgnore
    private Date startTime;

    @JsonIgnore
    private Date endTime;

    private Integer repeatCount;

    private Long repeatInterval;

    private String cronExpression;

    private String requestService;

    private String requestUrl;

    private String requestMethod;

    private String accessToken;

    private String requestBody;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getJobGroup() {
        return jobGroup;
    }

    public void setJobGroup(String jobGroup) {
        this.jobGroup = jobGroup;
    }

    public String getTriggerType() {
        return triggerType;
    }

    public void setTriggerType(String triggerType) {
        this.triggerType = triggerType;
    }

    public String getTriggerState() {
        return triggerState;
    }

    public void setTriggerState(String triggerState) {
        this.triggerState = triggerState;
    }

    public String getJobDescription() {
        return jobDescription;
    }

    public void setJobDescription(String jobDescription) {
        this.jobDescription = jobDescription;
    }

    public Integer getPriority() {
        return priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Integer getRepeatCount() {
        return repeatCount;
    }

    public void setRepeatCount(Integer repeatCount) {
        this.repeatCount = repeatCount;
    }

    public Long getRepeatInterval() {
        return repeatInterval;
    }

    public void setRepeatInterval(Long repeatInterval) {
        this.repeatInterval = repeatInterval;
    }

    public String getCronExpression() {
        return cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public String getRequestService() {
        return requestService;
    }

    public void setRequestService(String requestService) {
        this.requestService = requestService;
    }

    public String getRequestUrl() {
        return requestUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public String getRequestMethod() {
        return requestMethod;
    }

    public void setRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    public String getAccessToken() {
        return accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getRequestBody() {
        return requestBody;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    @Override
    public String toString() {
        return "JobInfo{"
                + "id=" + id
                + ", jobGroup='" + jobGroup + '\''
                + ", triggerType='" + triggerType + '\''
                + ", triggerState='" + triggerState + '\''
                + ", jobDescription='" + jobDescription + '\''
                + ", priority=" + priority
                + ", startTime=" + startTime
                + ", endTime=" + endTime
                + ", repeatCount=" + repeatCount
                + ", repeatInterval=" + repeatInterval
                + ", cronExpression='" + cronExpression + '\''
                + ", requestService='" + requestService + '\''
                + ", requestUrl='" + requestUrl + '\''
                + ", requestMethod='" + requestMethod + '\''
                + ", accessToken='" + accessToken + '\''
                + ", requestBody='" + requestBody + '\''
                + '}';
    }
}