package io.choerodon.scheduler.helper.util;

import io.choerodon.scheduler.helper.domain.JobInfo;

import org.springframework.web.bind.annotation.RequestMethod;

/**
 * 两个计划任务对象示例
 *
 * @author wuguokai
 */
public class JobGenerator {

    private JobGenerator() {
    }

    /**
     * 立刻执行且只执行一次的Job的半成品
     */
    public static JobInfo generateSimpleJob() {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setTriggerType("SIMPLE");
        jobInfo.setRequestMethod(RequestMethod.GET.name());
        jobInfo.setRepeatCount(0);
        return jobInfo;
    }

    /**
     * {@inheritDoc}
     * @return 每天凌晨1点执行的Job半成品
     */
    public static JobInfo generateCronJob() {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setTriggerType("CRON");
        jobInfo.setRequestMethod(RequestMethod.GET.name());
        jobInfo.setCronExpression("0 0 1 * * ?");
        return jobInfo;
    }
}

