/*
 * Decompiled with CFR 0.152.
 */
package io.chrisdavenport.cats.effect.time;

import cats.arrow.FunctionK;
import cats.effect.kernel.Clock;
import io.chrisdavenport.cats.effect.time.JavaTime$;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import scala.Function1;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\t-eaB\u001c9!\u0003\r\ta\u0011\u0005\u0006\u0017\u0002!\t\u0001\u0014\u0005\u0006!\u00021\t!\u0015\u0005\u0006O\u00021\t\u0001\u001b\u0005\u0006e\u00021\ta\u001d\u0005\u0006i\u00021\t!\u001e\u0005\u0006w\u00021\t\u0001 \u0005\u0006{\u00021\tA \u0005\b\u0003\u0013\u0001a\u0011AA\u0006\u0011\u001d\ti\u0001\u0001D\u0001\u0003\u001fAq!a\u0007\u0001\r\u0003\ti\u0002C\u0004\u0002 \u00011\t!!\t\t\u000f\u00055\u0002A\"\u0001\u00020!9\u0011\u0011\u0007\u0001\u0007\u0002\u0005M\u0002bBA \u0001\u0019\u0005\u0011\u0011\t\u0005\b\u0003\u0007\u0002A\u0011AA#\u000f\u001d\ti\t\u000fE\u0001\u0003\u001f3aa\u000e\u001d\t\u0002\u0005E\u0005bBAJ#\u0011\u0005\u0011Q\u0013\u0005\b\u0003/\u000bB\u0011AAM\u0011\u001d\ti+\u0005C\u0002\u0003_3a!!6\u0012\t\u0005]\u0007BCAt+\t\u0015\r\u0011b\u0001\u0002j\"Q\u0011Q^\u000b\u0003\u0002\u0003\u0006I!a;\t\u000f\u0005MU\u0003\"\u0001\u0002p\"1\u0001+\u0006C\u0001\u0003sDaaZ\u000b\u0005\u0002\u0005u\bB\u0002:\u0016\t\u0003\u0011\u0019\u0001\u0003\u0004u+\u0011\u0005!Q\u0001\u0005\u0007wV!\tAa\u0003\t\ru,B\u0011\u0001B\u0007\u0011\u001d\tI!\u0006C\u0001\u0005'Aq!!\u0004\u0016\t\u0003\u0011)\u0002C\u0004\u0002\u001cU!\tAa\u0007\t\u000f\u0005}Q\u0003\"\u0001\u0003\u001e!9\u0011QF\u000b\u0005\u0002\t\r\u0002bBA\u0019+\u0011\u0005!Q\u0005\u0005\b\u0003\u007f)B\u0011\u0001B\u0016\r\u0019\u0011i#\u0005\u0003\u00030!Q!q\b\u0014\u0003\u0002\u0003\u0006IA!\u0011\t\u0015\u0005mcE!A!\u0002\u0013\u0011i\u0005C\u0004\u0002\u0014\u001a\"\tAa\u0014\t\rA3C\u0011\u0001B,\u0011\u00199g\u0005\"\u0001\u0003\\!1AO\nC\u0001\u0005CBaa\u001f\u0014\u0005\u0002\t\u001d\u0004B\u0002:'\t\u0003\u0011I\u0007\u0003\u0004~M\u0011\u0005!1\u000e\u0005\b\u0003\u00131C\u0011\u0001B9\u0011\u001d\tiA\nC\u0001\u0005gBq!a\b'\t\u0003\u0011I\bC\u0004\u0002.\u0019\"\tAa \t\u000f\u0005ma\u0005\"\u0001\u0003\u0002\"9\u0011\u0011\u0007\u0014\u0005\u0002\t\r\u0005bBA M\u0011\u0005!\u0011\u0012\u0002\t\u0015\u00064\u0018\rV5nK*\u0011\u0011HO\u0001\u0005i&lWM\u0003\u0002<y\u00051QM\u001a4fGRT!!\u0010 \u0002\t\r\fGo\u001d\u0006\u0003\u007f\u0001\u000bab\u00195sSN$\u0017M^3oa>\u0014HOC\u0001B\u0003\tIwn\u0001\u0001\u0016\u0005\u0011#6C\u0001\u0001F!\t1\u0015*D\u0001H\u0015\u0005A\u0015!B:dC2\f\u0017B\u0001&H\u0005\u0019\te.\u001f*fM\u00061A%\u001b8ji\u0012\"\u0012!\u0014\t\u0003\r:K!aT$\u0003\tUs\u0017\u000e^\u0001\u000bO\u0016$\u0018J\\:uC:$X#\u0001*\u0011\u0007M#\u0006\r\u0004\u0001\u0005\u000bU\u0003!\u0019\u0001,\u0003\u0003\u0019+\"a\u00160\u0012\u0005a[\u0006C\u0001$Z\u0013\tQvIA\u0004O_RD\u0017N\\4\u0011\u0005\u0019c\u0016BA/H\u0005\r\te.\u001f\u0003\u0006?R\u0013\ra\u0016\u0002\u0005?\u0012\"\u0013\u0007\u0005\u0002bK6\t!M\u0003\u0002:G*\tA-\u0001\u0003kCZ\f\u0017B\u00014c\u0005\u001dIen\u001d;b]R\fAbZ3u\u0019>\u001c\u0017\r\u001c#bi\u0016$\"![7\u0011\u0007M#&\u000e\u0005\u0002bW&\u0011AN\u0019\u0002\n\u0019>\u001c\u0017\r\u001c#bi\u0016DQA\\\u0002A\u0002=\fAA_8oKB\u0011\u0011\r]\u0005\u0003c\n\u0014aAW8oK&#\u0017aD4fi2{7-\u00197ECR,W\u000bV\"\u0016\u0003%\f\u0001cZ3u\u0019>\u001c\u0017\r\u001c#bi\u0016$\u0016.\\3\u0015\u0005YT\bcA*UoB\u0011\u0011\r_\u0005\u0003s\n\u0014Q\u0002T8dC2$\u0015\r^3US6,\u0007\"\u00028\u0006\u0001\u0004y\u0017aE4fi2{7-\u00197ECR,G+[7f+R\u001bU#\u0001<\u0002\u0019\u001d,G\u000fT8dC2$\u0016.\\3\u0015\u0007}\f9\u0001\u0005\u0003T)\u0006\u0005\u0001cA1\u0002\u0004%\u0019\u0011Q\u00012\u0003\u00131{7-\u00197US6,\u0007\"\u00028\b\u0001\u0004y\u0017aD4fi2{7-\u00197US6,W\u000bV\"\u0016\u0003}\fqaZ3u3\u0016\f'\u000f\u0006\u0003\u0002\u0012\u0005e\u0001\u0003B*U\u0003'\u00012!YA\u000b\u0013\r\t9B\u0019\u0002\u00053\u0016\f'\u000fC\u0003o\u0013\u0001\u0007q.\u0001\u0006hKRLV-\u0019:V)\u000e+\"!!\u0005\u0002\u0019\u001d,G/W3be6{g\u000e\u001e5\u0015\t\u0005\r\u00121\u0006\t\u0005'R\u000b)\u0003E\u0002b\u0003OI1!!\u000bc\u0005%IV-\u0019:N_:$\b\u000eC\u0003o\u0017\u0001\u0007q.A\bhKRLV-\u0019:N_:$\b.\u0016+D+\t\t\u0019#\u0001\thKRTvN\\3e\t\u0006$X\rV5nKR!\u0011QGA\u001f!\u0011\u0019F+a\u000e\u0011\u0007\u0005\fI$C\u0002\u0002<\t\u0014QBW8oK\u0012$\u0015\r^3US6,\u0007\"\u00028\u000e\u0001\u0004y\u0017aE4fij{g.\u001a3ECR,G+[7f+R\u001bUCAA\u001b\u0003\u0011i\u0017\r]&\u0016\t\u0005\u001d\u0013q\n\u000b\u0005\u0003\u0013\nI\u0006E\u0003\u0002L\u0001\ti%D\u00019!\r\u0019\u0016q\n\u0003\b\u0003#z!\u0019AA*\u0005\u00059UcA,\u0002V\u00119\u0011qKA(\u0005\u00049&\u0001B0%IIBq!a\u0017\u0010\u0001\u0004\ti&\u0001\u0002gWBA\u0011qLA9\u0003o\niE\u0004\u0003\u0002b\u0005-d\u0002BA2\u0003Sj!!!\u001a\u000b\u0007\u0005\u001d$)\u0001\u0004=e>|GOP\u0005\u0002{%!\u0011QNA8\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011!P\u0005\u0005\u0003g\n)H\u0001\b%i&dG-\u001a\u0013he\u0016\fG/\u001a:\u000b\t\u00055\u0014q\u000e\t\u0003'RCs\u0001AA>\u0003\u000f\u000bI\t\u0005\u0003\u0002~\u0005\rUBAA@\u0015\r\t\tiR\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAC\u0003\u007f\u0012\u0001#[7qY&\u001c\u0017\u000e\u001e(pi\u001a{WO\u001c3\u0002\u00075\u001cx-\t\u0002\u0002\f\u0006\tibQ1o]>$\bEZ5oI\u0002JW\u000e\u001d7jG&$\bE^1mk\u0016\u0004cm\u001c:!\u0015\u00064\u0018\rV5nKn#3PR?^])\u0011U/\u001b7eS:<\u0007\u0005\u001e5jg\u0002JW\u000e\u001d7jG&$\bE^1mk\u0016\u0004C-\u001a9f]\u0012\u001c\be\u001c8!Q\u00064\u0018N\\4!C:\u0004\u0013.\u001c9mS\u000eLGOC\"m_\u000e\\7\fJ>G{v\u0003sN\u001d\u0011t_6,\u0007%Z9vSZ\fG.\u001a8uAQL\b/\u001a\u0018\u0002\u0011)\u000bg/\u0019+j[\u0016\u00042!a\u0013\u0012'\t\tR)\u0001\u0004=S:LGO\u0010\u000b\u0003\u0003\u001f\u000bQ!\u00199qYf,B!a'\u0002\"R!\u0011QTAU!\u0015\tY\u0005AAP!\r\u0019\u0016\u0011\u0015\u0003\u0007+N\u0011\r!a)\u0016\u0007]\u000b)\u000bB\u0004\u0002(\u0006\u0005&\u0019A,\u0003\t}#Ce\r\u0005\b\u0003W\u001b\u00029AAO\u0003\t)g/A\u0005ge>l7\t\\8dWV!\u0011\u0011WA\\)\u0011\t\u0019,a0\u0011\u000b\u0005-\u0003!!.\u0011\u0007M\u000b9\f\u0002\u0004V)\t\u0007\u0011\u0011X\u000b\u0004/\u0006mFaBA_\u0003o\u0013\ra\u0016\u0002\u0005?\u0012\"C\u0007C\u0004\u0002BR\u0001\u001d!a1\u0002\u0003\r\u0003b!!2\u0002P\u0006Uf\u0002BAd\u0003\u0017tA!!\u0019\u0002J&\u00191(a\u001c\n\t\u00055\u0014Q\u001a\u0006\u0004w\u0005=\u0014\u0002BAi\u0003'\u0014Qa\u00117pG.TA!!\u001c\u0002N\ni1\t\\8dW*\u000bg/\u0019+j[\u0016,B!!7\u0002`N!Q#RAn!\u0015\tY\u0005AAo!\r\u0019\u0016q\u001c\u0003\u0007+V\u0011\r!!9\u0016\u0007]\u000b\u0019\u000fB\u0004\u0002f\u0006}'\u0019A,\u0003\t}#C%N\u0001\u0002GV\u0011\u00111\u001e\t\u0007\u0003\u000b\fy-!8\u0002\u0005\r\u0004CCAAy)\u0011\t\u00190a>\u0011\u000b\u0005UX#!8\u000e\u0003EAq!a:\u0019\u0001\b\tY/\u0006\u0002\u0002|B!1+a8a)\u0011\tyP!\u0001\u0011\tM\u000byN\u001b\u0005\u0006]j\u0001\ra\\\u000b\u0003\u0003\u007f$BAa\u0002\u0003\nA!1+a8x\u0011\u0015qG\u00041\u0001p+\t\u00119\u0001\u0006\u0003\u0003\u0010\tE\u0001#B*\u0002`\u0006\u0005\u0001\"\u00028\u001f\u0001\u0004yWC\u0001B\b)\u0011\u00119B!\u0007\u0011\u000bM\u000by.a\u0005\t\u000b9\u0004\u0003\u0019A8\u0016\u0005\t]A\u0003\u0002B\u0010\u0005C\u0001RaUAp\u0003KAQA\u001c\u0012A\u0002=,\"Aa\b\u0015\t\t\u001d\"\u0011\u0006\t\u0006'\u0006}\u0017q\u0007\u0005\u0006]\u0012\u0002\ra\\\u000b\u0003\u0005O\u0011\u0001CS1wCRKW.Z'ba.KU\u000e\u001d7\u0016\r\tE\"Q\tB\u001c'\u00111SIa\r\u0011\u000b\u0005-\u0003A!\u000e\u0011\u0007M\u00139\u0004B\u0004\u0002R\u0019\u0012\rA!\u000f\u0016\u0007]\u0013Y\u0004B\u0004\u0003>\t]\"\u0019A,\u0003\t}#CeN\u0001\u0005E\u0006\u001cX\rE\u0003\u0002L\u0001\u0011\u0019\u0005E\u0002T\u0005\u000b\"a!\u0016\u0014C\u0002\t\u001dScA,\u0003J\u00119!1\nB#\u0005\u00049&\u0001B0%IY\u0002\u0002\"a\u0018\u0002r\t\r#Q\u0007\u000b\u0007\u0005#\u0012\u0019F!\u0016\u0011\u000f\u0005UhEa\u0011\u00036!9!qH\u0015A\u0002\t\u0005\u0003bBA.S\u0001\u0007!QJ\u000b\u0003\u00053\u0002Ba\u0015B\u001cAR!!Q\fB0!\u0011\u0019&q\u00076\t\u000b9\\\u0003\u0019A8\u0015\t\t\r$Q\r\t\u0005'\n]r\u000fC\u0003oY\u0001\u0007q.\u0006\u0002\u0003dU\u0011!Q\f\u000b\u0005\u0005[\u0012y\u0007E\u0003T\u0005o\t\t\u0001C\u0003o_\u0001\u0007q.\u0006\u0002\u0003nQ!!Q\u000fB<!\u0015\u0019&qGA\n\u0011\u0015q\u0017\u00071\u0001p)\u0011\u0011YH! \u0011\u000bM\u00139$!\n\t\u000b9\u0014\u0004\u0019A8\u0016\u0005\tmTC\u0001B;)\u0011\u0011)Ia\"\u0011\u000bM\u00139$a\u000e\t\u000b9,\u0004\u0019A8\u0016\u0005\t\u0015\u0005")
public interface JavaTime<F> {
    public static <F> JavaTime<F> fromClock(Clock<F> C) {
        return JavaTime$.MODULE$.fromClock(C);
    }

    public static <F> JavaTime<F> apply(JavaTime<F> ev) {
        return JavaTime$.MODULE$.apply(ev);
    }

    public F getInstant();

    public F getLocalDate(ZoneId var1);

    public F getLocalDateUTC();

    public F getLocalDateTime(ZoneId var1);

    public F getLocalDateTimeUTC();

    public F getLocalTime(ZoneId var1);

    public F getLocalTimeUTC();

    public F getYear(ZoneId var1);

    public F getYearUTC();

    public F getYearMonth(ZoneId var1);

    public F getYearMonthUTC();

    public F getZonedDateTime(ZoneId var1);

    public F getZonedDateTimeUTC();

    default public <G$> JavaTime<G$> mapK(FunctionK<F, G$> fk) {
        return new JavaTimeMapKImpl<F, G$>(this, fk);
    }

    public static void $init$(JavaTime $this) {
    }

    private static class ClockJavaTime<F>
    implements JavaTime<F> {
        private final Clock<F> c;

        @Override
        public <G$> JavaTime<G$> mapK(FunctionK<F, G$> fk) {
            return ((JavaTime)this).mapK(fk);
        }

        public Clock<F> c() {
            return this.c;
        }

        @Override
        public F getInstant() {
            return (F)this.c().applicative().map(this.c().realTime(), (Function1 & Serializable)d -> Instant.ofEpochMilli(d.toMillis()));
        }

        @Override
        public F getLocalDate(ZoneId zone) {
            return (F)this.c().applicative().map(this.getLocalDateTime(zone), (Function1 & Serializable)x$1 -> x$1.toLocalDate());
        }

        @Override
        public F getLocalDateUTC() {
            return this.getLocalDate(ZoneOffset.UTC);
        }

        @Override
        public F getLocalDateTime(ZoneId zone) {
            return (F)this.c().applicative().map(this.getInstant(), (Function1 & Serializable)x$2 -> LocalDateTime.ofInstant(x$2, zone));
        }

        @Override
        public F getLocalDateTimeUTC() {
            return this.getLocalDateTime(ZoneOffset.UTC);
        }

        @Override
        public F getLocalTime(ZoneId zone) {
            return (F)this.c().applicative().map(this.getLocalDateTime(zone), (Function1 & Serializable)x$3 -> x$3.toLocalTime());
        }

        @Override
        public F getLocalTimeUTC() {
            return this.getLocalTime(ZoneOffset.UTC);
        }

        @Override
        public F getYear(ZoneId zone) {
            return (F)this.c().applicative().map(this.getLocalDate(zone), (Function1 & Serializable)d -> Year.of(d.getYear()));
        }

        @Override
        public F getYearUTC() {
            return this.getYear(ZoneOffset.UTC);
        }

        @Override
        public F getYearMonth(ZoneId zone) {
            return (F)this.c().applicative().map(this.getLocalDate(zone), (Function1 & Serializable)d -> YearMonth.of(d.getYear(), d.getMonth()));
        }

        @Override
        public F getYearMonthUTC() {
            return this.getYearMonth(ZoneOffset.UTC);
        }

        @Override
        public F getZonedDateTime(ZoneId zone) {
            return (F)this.c().applicative().map(this.getInstant(), (Function1 & Serializable)x$4 -> ZonedDateTime.ofInstant(x$4, zone));
        }

        @Override
        public F getZonedDateTimeUTC() {
            return this.getZonedDateTime(ZoneOffset.UTC);
        }

        public ClockJavaTime(Clock<F> c) {
            this.c = c;
            JavaTime.$init$(this);
        }
    }

    private static class JavaTimeMapKImpl<F, G>
    implements JavaTime<G> {
        private final JavaTime<F> base;
        private final FunctionK<F, G> fk;

        @Override
        public <G$> JavaTime<G$> mapK(FunctionK<G, G$> fk) {
            return ((JavaTime)this).mapK(fk);
        }

        @Override
        public G getInstant() {
            return (G)this.fk.apply(this.base.getInstant());
        }

        @Override
        public G getLocalDate(ZoneId zone) {
            return (G)this.fk.apply(this.base.getLocalDate(zone));
        }

        @Override
        public G getLocalDateTime(ZoneId zone) {
            return (G)this.fk.apply(this.base.getLocalDateTime(zone));
        }

        @Override
        public G getLocalDateTimeUTC() {
            return (G)this.fk.apply(this.base.getLocalDateTimeUTC());
        }

        @Override
        public G getLocalDateUTC() {
            return (G)this.fk.apply(this.base.getLocalDateUTC());
        }

        @Override
        public G getLocalTime(ZoneId zone) {
            return (G)this.fk.apply(this.base.getLocalTime(zone));
        }

        @Override
        public G getLocalTimeUTC() {
            return (G)this.fk.apply(this.base.getLocalTimeUTC());
        }

        @Override
        public G getYear(ZoneId zone) {
            return (G)this.fk.apply(this.base.getYear(zone));
        }

        @Override
        public G getYearMonth(ZoneId zone) {
            return (G)this.fk.apply(this.base.getYearMonth(zone));
        }

        @Override
        public G getYearMonthUTC() {
            return (G)this.fk.apply(this.base.getYearMonthUTC());
        }

        @Override
        public G getYearUTC() {
            return (G)this.fk.apply(this.base.getYearUTC());
        }

        @Override
        public G getZonedDateTime(ZoneId zone) {
            return (G)this.fk.apply(this.base.getZonedDateTime(zone));
        }

        @Override
        public G getZonedDateTimeUTC() {
            return (G)this.fk.apply(this.base.getZonedDateTimeUTC());
        }

        public JavaTimeMapKImpl(JavaTime<F> base, FunctionK<F, G> fk) {
            this.base = base;
            this.fk = fk;
            JavaTime.$init$(this);
        }
    }
}

