/*
 * Decompiled with CFR 0.152.
 */
package io.ciera.runtime.api.exceptions;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;

public class ActionException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final Object data;
    private final List<StackTraceElement> stack;

    public ActionException() {
        this(null, (Object)null);
    }

    public ActionException(String message) {
        this(message, (Object)null);
    }

    public ActionException(Throwable cause) {
        this(null, (Object)null);
        List<StackTraceElement> trace = List.of(this.getStackTrace());
        cause.setStackTrace((StackTraceElement[])Stream.of(cause.getStackTrace()).filter(ste -> !trace.contains(ste)).toArray(StackTraceElement[]::new));
        this.initCause(cause);
    }

    public ActionException(Object data) {
        this(null, data);
    }

    private ActionException(String message, Object data) {
        super(message);
        this.data = data;
        this.stack = new LinkedList<StackTraceElement>();
    }

    public void updateStack(String parentName, String bodyName, String fileName, int lineNumber) {
        this.stack.add(new StackTraceElement(parentName, bodyName, fileName, lineNumber));
        this.setStackTrace(this.stack.toArray(new StackTraceElement[0]));
    }

    public Object getData() {
        return this.data;
    }
}

