/*
 * Decompiled with CFR 0.152.
 */
package io.ciera.runtime.api.types;

import io.ciera.runtime.api.exceptions.DeserializationException;
import io.ciera.runtime.api.types.TimeStamp;
import java.io.Serializable;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;

public class Duration
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Duration ZERO = new Duration();
    private final long value;

    public Duration() {
        this(0L);
    }

    public Duration(long value) {
        this.value = value;
    }

    public Duration(long value, TemporalUnit unit) {
        this(java.time.Duration.of(value, unit).toNanos());
    }

    public Duration(Duration o) {
        this(o.getValue());
    }

    public long getValue() {
        return this.value;
    }

    public String toString() {
        return java.time.Duration.of(this.getValue(), ChronoUnit.NANOS).toString();
    }

    public static Duration fromString(String s) {
        try {
            return new Duration(java.time.Duration.parse(s).toNanos());
        }
        catch (NullPointerException | DateTimeParseException e) {
            throw new DeserializationException("Could not parse duration", e);
        }
    }

    public TimeStamp add(TimeStamp t) {
        return new TimeStamp(this.value + t.getValue());
    }

    public Duration add(Duration d) {
        return new Duration(this.value + d.getValue());
    }

    public Duration subtract(Duration d) {
        return new Duration(this.value - d.getValue());
    }

    public Duration multiply(Number n) {
        return new Duration(this.value * n.longValue());
    }

    public Duration divide(Number n) {
        return new Duration(this.value / n.longValue());
    }

    public long divide(Duration n) {
        return this.value / n.value;
    }
}

