/*
 * Decompiled with CFR 0.152.
 */
package io.ciera.runtime.api.types;

import io.ciera.runtime.api.time.SystemClock;
import io.ciera.runtime.api.types.Duration;
import java.io.Serializable;

public class TimeStamp
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final TimeStamp ZERO = new TimeStamp();
    private final long value;

    public TimeStamp() {
        this(0L);
    }

    public TimeStamp(long value) {
        this.value = value;
    }

    public TimeStamp(TimeStamp o) {
        this(o.getValue());
    }

    public long getValue() {
        return this.value;
    }

    public static TimeStamp now(SystemClock clock) {
        return new TimeStamp(clock.getTime());
    }

    public static TimeStamp fromString(String s) {
        return new TimeStamp(Long.parseLong(s));
    }

    public TimeStamp add(Duration d) {
        return new TimeStamp(this.value + d.getValue());
    }

    public TimeStamp subtract(Duration d) {
        return new TimeStamp(this.value - d.getValue());
    }

    public Duration subtract(TimeStamp t) {
        return new Duration(this.value - t.getValue());
    }

    public String toString() {
        return Long.toString(this.value);
    }
}

