/*
 * Decompiled with CFR 0.152.
 */
package io.circe.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import io.circe.Json;
import io.circe.Json$JNull$;
import io.circe.JsonBigDecimal;
import io.circe.JsonBiggerDecimal;
import io.circe.JsonDecimal;
import io.circe.JsonDouble;
import io.circe.JsonFloat;
import io.circe.JsonLong;
import io.circe.JsonNumber;
import io.circe.JsonObject;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.Vector;
import scala.runtime.BoxedUnit;

public final class CirceJsonSerializer$
extends JsonSerializer<Json> {
    public static CirceJsonSerializer$ MODULE$;

    static {
        new CirceJsonSerializer$();
    }

    public final void serialize(Json value, JsonGenerator json, SerializerProvider provider) {
        Json json2 = value;
        if (json2 instanceof Json.JNumber) {
            Json.JNumber jNumber = (Json.JNumber)json2;
            JsonNumber v = jNumber.value();
            JsonNumber jsonNumber = v;
            if (jsonNumber instanceof JsonLong) {
                JsonLong jsonLong = (JsonLong)jsonNumber;
                long x = jsonLong.value();
                json.writeNumber(x);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (jsonNumber instanceof JsonDouble) {
                JsonDouble jsonDouble = (JsonDouble)jsonNumber;
                double x = jsonDouble.value();
                json.writeNumber(x);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (jsonNumber instanceof JsonFloat) {
                JsonFloat jsonFloat = (JsonFloat)jsonNumber;
                float x = jsonFloat.value();
                json.writeNumber(x);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (jsonNumber instanceof JsonDecimal) {
                JsonDecimal jsonDecimal = (JsonDecimal)jsonNumber;
                String x = jsonDecimal.input();
                json.writeString(x);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (jsonNumber instanceof JsonBiggerDecimal) {
                JsonBiggerDecimal jsonBiggerDecimal = (JsonBiggerDecimal)jsonNumber;
                String x = jsonBiggerDecimal.input();
                json.writeString(x);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (jsonNumber instanceof JsonBigDecimal) {
                BoxedUnit boxedUnit;
                JsonBigDecimal jsonBigDecimal = (JsonBigDecimal)jsonNumber;
                BigDecimal x = jsonBigDecimal.value();
                String raw = x.stripTrailingZeros().toPlainString();
                if (raw.contains(".")) {
                    json.writeTree((TreeNode)new DecimalNode(new BigDecimal(raw)));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    json.writeTree((TreeNode)new BigIntegerNode(new BigInteger(raw)));
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                throw new MatchError((Object)jsonNumber);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (json2 instanceof Json.JString) {
            Json.JString jString = (Json.JString)json2;
            String v = jString.value();
            json.writeString(v);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (json2 instanceof Json.JBoolean) {
            Json.JBoolean jBoolean = (Json.JBoolean)json2;
            boolean v = jBoolean.value();
            json.writeBoolean(v);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (json2 instanceof Json.JArray) {
            Json.JArray jArray = (Json.JArray)json2;
            Vector elements = jArray.value();
            json.writeStartArray();
            elements.foreach((Function1 & Serializable & scala.Serializable)t -> {
                CirceJsonSerializer$.MODULE$.serialize(t, json, provider);
                return BoxedUnit.UNIT;
            });
            json.writeEndArray();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (json2 instanceof Json.JObject) {
            Json.JObject jObject = (Json.JObject)json2;
            JsonObject values = jObject.value();
            json.writeStartObject();
            values.toList().foreach((Function1 & Serializable & scala.Serializable)t -> {
                CirceJsonSerializer$.$anonfun$serialize$2(json, provider, t);
                return BoxedUnit.UNIT;
            });
            json.writeEndObject();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Json$JNull$.MODULE$.equals(json2)) {
            json.writeNull();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)json2);
        }
    }

    public static final /* synthetic */ void $anonfun$serialize$2(JsonGenerator json$1, SerializerProvider provider$1, Tuple2 t) {
        json$1.writeFieldName((String)t._1());
        MODULE$.serialize((Json)t._2(), json$1, provider$1);
    }

    private CirceJsonSerializer$() {
        MODULE$ = this;
    }
}

