/*
 * Decompiled with CFR 0.152.
 */
package io.circe.jackson;

import cats.data.NonEmptyList;
import cats.data.Validated;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.circe.Decoder;
import io.circe.Error;
import io.circe.Json;
import io.circe.Json$;
import io.circe.JsonBigDecimal;
import io.circe.JsonBiggerDecimal;
import io.circe.JsonDecimal;
import io.circe.JsonDouble;
import io.circe.JsonFloat;
import io.circe.JsonLong;
import io.circe.JsonNumber;
import io.circe.JsonObject;
import io.circe.Parser;
import io.circe.ParsingFailure;
import io.circe.jackson.JacksonCompat;
import io.circe.jackson.JacksonCompat$class;
import io.circe.jackson.JacksonParser;
import io.circe.jackson.JacksonParser$class;
import io.circe.jackson.WithJacksonMapper;
import io.circe.jackson.package;
import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigInt$;
import scala.util.Either;

public final class package$
extends WithJacksonMapper
implements JacksonParser,
JacksonCompat {
    public static final package$ MODULE$;
    private final Json io$circe$jackson$package$$negativeZeroJson;

    static {
        new package$();
    }

    @Override
    public ObjectWriter makeWriter(ObjectMapper mapper) {
        return JacksonCompat$class.makeWriter(this, mapper);
    }

    @Override
    public void handleUnexpectedToken(DeserializationContext context, Class<?> klass, JsonParser parser) {
        JacksonCompat$class.handleUnexpectedToken(this, context, klass, parser);
    }

    @Override
    public final Either<ParsingFailure, Json> parse(String input) {
        return JacksonParser$class.parse(this, input);
    }

    @Override
    public final Either<ParsingFailure, Json> parseFile(File file) {
        return JacksonParser$class.parseFile(this, file);
    }

    @Override
    public final Either<ParsingFailure, Json> parseByteArray(byte[] bytes) {
        return JacksonParser$class.parseByteArray(this, bytes);
    }

    @Override
    public final <A> Either<Error, A> decodeByteArray(byte[] bytes, Decoder<A> evidence$1) {
        return JacksonParser$class.decodeByteArray(this, bytes, evidence$1);
    }

    @Override
    public final <A> Validated<NonEmptyList<Error>, A> decodeByteArrayAccumulating(byte[] bytes, Decoder<A> evidence$2) {
        return JacksonParser$class.decodeByteArrayAccumulating(this, bytes, evidence$2);
    }

    @Override
    public final <A> Either<Error, A> decodeFile(File file, Decoder<A> evidence$3) {
        return JacksonParser$class.decodeFile(this, file, evidence$3);
    }

    @Override
    public final <A> Validated<NonEmptyList<Error>, A> decodeFileAccumulating(File file, Decoder<A> evidence$4) {
        return JacksonParser$class.decodeFileAccumulating(this, file, evidence$4);
    }

    public final <A> Either<Error, A> finishDecode(Either<ParsingFailure, Json> input, Decoder<A> decoder) {
        return Parser.class.finishDecode((Parser)this, input, decoder);
    }

    public final <A> Validated<NonEmptyList<Error>, A> finishDecodeAccumulating(Either<ParsingFailure, Json> input, Decoder<A> decoder) {
        return Parser.class.finishDecodeAccumulating((Parser)this, input, decoder);
    }

    public final <A> Either<Error, A> decode(String input, Decoder<A> evidence$1) {
        return Parser.class.decode((Parser)this, (String)input, evidence$1);
    }

    public final <A> Validated<NonEmptyList<Error>, A> decodeAccumulating(String input, Decoder<A> evidence$2) {
        return Parser.class.decodeAccumulating((Parser)this, (String)input, evidence$2);
    }

    private void writeJson(Writer w, Json j) {
        JsonGenerator gen = this.jsonGenerator(w);
        this.makeWriter(this.mapper()).writeValue(gen, (Object)j);
        w.flush();
    }

    public final String jacksonPrint(Json json) {
        StringWriter sw = new StringWriter();
        this.writeJson(sw, json);
        return sw.toString();
    }

    public final ByteBuffer jacksonPrintByteBuffer(Json json) {
        package.EnhancedByteArrayOutputStream bytes = new package.EnhancedByteArrayOutputStream();
        this.writeJson(new BufferedWriter(new OutputStreamWriter((OutputStream)bytes, "UTF-8")), json);
        return bytes.toByteBuffer();
    }

    public Json io$circe$jackson$package$$negativeZeroJson() {
        return this.io$circe$jackson$package$$negativeZeroJson;
    }

    public final JsonNode circeToJackson(Json json) {
        return (JsonNode)json.fold((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final NullNode apply() {
                return NullNode.instance;
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BooleanNode apply(boolean x$1) {
                return BooleanNode.valueOf((boolean)x$1);
            }
        }, (Function1)new Serializable(json){
            public static final long serialVersionUID = 0L;
            private final Json json$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final JsonNode apply(JsonNumber number) {
                LongNode longNode;
                DoubleNode doubleNode;
                Json json = this.json$1;
                Json json2 = package$.MODULE$.io$circe$jackson$package$$negativeZeroJson();
                if (!(json != null ? !json.equals(json2) : json2 != null)) {
                    doubleNode = DoubleNode.valueOf((double)number.toDouble());
                    return doubleNode;
                }
                JsonNumber jsonNumber = number;
                boolean bl = jsonNumber instanceof JsonBiggerDecimal ? true : jsonNumber instanceof JsonBigDecimal;
                if (bl) {
                    longNode = (JsonNode)number.toBigDecimal().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final DecimalNode apply(BigDecimal bigDecimal) {
                            return DecimalNode.valueOf((java.math.BigDecimal)bigDecimal.underlying());
                        }
                    }).getOrElse((Function0)new Serializable(this, number){
                        public static final long serialVersionUID = 0L;
                        private final JsonNumber number$1;

                        public final TextNode apply() {
                            return TextNode.valueOf((String)this.number$1.toString());
                        }
                        {
                            this.number$1 = number$1;
                        }
                    });
                } else if (jsonNumber instanceof JsonLong) {
                    JsonLong jsonLong = (JsonLong)jsonNumber;
                    long x = jsonLong.value();
                    longNode = LongNode.valueOf((long)x);
                } else if (jsonNumber instanceof JsonDouble) {
                    JsonDouble jsonDouble = (JsonDouble)jsonNumber;
                    double x = jsonDouble.value();
                    longNode = DoubleNode.valueOf((double)x);
                } else if (jsonNumber instanceof JsonFloat) {
                    JsonFloat jsonFloat = (JsonFloat)jsonNumber;
                    float x = jsonFloat.value();
                    longNode = FloatNode.valueOf((float)x);
                } else {
                    TextNode textNode;
                    if (!(jsonNumber instanceof JsonDecimal)) throw new MatchError((Object)jsonNumber);
                    JsonDecimal jsonDecimal = (JsonDecimal)jsonNumber;
                    String x = jsonDecimal.value();
                    try {
                        textNode = DecimalNode.valueOf((java.math.BigDecimal)new java.math.BigDecimal(x));
                    }
                    catch (NumberFormatException numberFormatException) {
                        textNode = TextNode.valueOf((String)x);
                    }
                    longNode = textNode;
                }
                doubleNode = longNode;
                return doubleNode;
            }
            {
                this.json$1 = json$1;
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TextNode apply(String x$2) {
                return TextNode.valueOf((String)x$2);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayNode apply(Vector<Json> array) {
                return JsonNodeFactory.instance.arrayNode().addAll((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)array.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JsonNode apply(Json json) {
                        return package$.MODULE$.circeToJackson(json);
                    }
                }, Vector$.MODULE$.canBuildFrom())).asJava());
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonNode apply(JsonObject obj) {
                return JsonNodeFactory.instance.objectNode().setAll((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)obj.toMap().mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JsonNode apply(Json json) {
                        return package$.MODULE$.circeToJackson(json);
                    }
                }).toMap(Predef$.MODULE$.$conforms())).asJava());
            }
        });
    }

    public final Json jacksonToCirce(JsonNode node) {
        JsonNodeType jsonNodeType = node.getNodeType();
        Json json = JsonNodeType.BOOLEAN.equals(jsonNodeType) ? Json$.MODULE$.fromBoolean(node.asBoolean()) : (JsonNodeType.STRING.equals(jsonNodeType) ? Json$.MODULE$.fromString(node.asText()) : (JsonNodeType.NUMBER.equals(jsonNodeType) ? (node.isFloatingPointNumber() ? Json$.MODULE$.fromBigDecimal(BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(new java.math.BigDecimal(node.asText()))) : Json$.MODULE$.fromBigInt(BigInt$.MODULE$.javaBigInteger2bigInt(node.bigIntegerValue()))) : (JsonNodeType.ARRAY.equals(jsonNodeType) ? Json$.MODULE$.fromValues(((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(node.elements()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Json apply(JsonNode node) {
                return package$.MODULE$.jacksonToCirce(node);
            }
        }).toIterable()) : (JsonNodeType.OBJECT.equals(jsonNodeType) ? Json$.MODULE$.fromFields(((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(node.fields()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Json> apply(Map.Entry<String, JsonNode> m) {
                return new Tuple2((Object)m.getKey(), (Object)package$.MODULE$.jacksonToCirce(m.getValue()));
            }
        }).toIterable()) : Json$.MODULE$.Null()))));
        return json;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private package$() {
        MODULE$ = this;
        Parser.class.$init$((Parser)this);
        JacksonParser$class.$init$(this);
        JacksonCompat$class.$init$(this);
        this.io$circe$jackson$package$$negativeZeroJson = Json$.MODULE$.fromDoubleOrNull(-0.0);
    }
}

