/*
 * Decompiled with CFR 0.152.
 */
package io.circe.jackson;

import cats.data.NonEmptyList;
import cats.data.Validated;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.circe.Decoder;
import io.circe.Error;
import io.circe.Json;
import io.circe.Json$;
import io.circe.JsonBigDecimal;
import io.circe.JsonBiggerDecimal;
import io.circe.JsonDecimal;
import io.circe.JsonDouble;
import io.circe.JsonFloat;
import io.circe.JsonLong;
import io.circe.JsonNumber;
import io.circe.Parser;
import io.circe.ParsingFailure;
import io.circe.jackson.JacksonCompat;
import io.circe.jackson.JacksonParser;
import io.circe.jackson.WithJacksonMapper;
import io.circe.jackson.package;
import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Collection;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Vector$;
import scala.math.BigDecimal$;
import scala.math.BigInt$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

public final class package$
extends WithJacksonMapper
implements JacksonParser,
JacksonCompat {
    public static package$ MODULE$;
    private final Json negativeZeroJson;

    static {
        new package$();
    }

    @Override
    public ObjectWriter makeWriter(ObjectMapper mapper) {
        return JacksonCompat.makeWriter$(this, mapper);
    }

    @Override
    public void handleUnexpectedToken(DeserializationContext context, Class<?> klass, JsonParser parser) {
        JacksonCompat.handleUnexpectedToken$(this, context, klass, parser);
    }

    @Override
    public JsonNode objectNodeSetAll(ObjectNode node, java.util.Map<String, JsonNode> fields) {
        return JacksonCompat.objectNodeSetAll$(this, node, fields);
    }

    @Override
    public final Either<ParsingFailure, Json> parse(String input) {
        return JacksonParser.parse$(this, input);
    }

    @Override
    public final Either<ParsingFailure, Json> parseFile(File file) {
        return JacksonParser.parseFile$(this, file);
    }

    @Override
    public final Either<ParsingFailure, Json> parseByteArray(byte[] bytes) {
        return JacksonParser.parseByteArray$(this, bytes);
    }

    @Override
    public final <A> Either<Error, A> decodeByteArray(byte[] bytes, Decoder<A> evidence$1) {
        return JacksonParser.decodeByteArray$(this, bytes, evidence$1);
    }

    @Override
    public final <A> Validated<NonEmptyList<Error>, A> decodeByteArrayAccumulating(byte[] bytes, Decoder<A> evidence$2) {
        return JacksonParser.decodeByteArrayAccumulating$(this, bytes, evidence$2);
    }

    @Override
    public final <A> Either<Error, A> decodeFile(File file, Decoder<A> evidence$3) {
        return JacksonParser.decodeFile$(this, file, evidence$3);
    }

    @Override
    public final <A> Validated<NonEmptyList<Error>, A> decodeFileAccumulating(File file, Decoder<A> evidence$4) {
        return JacksonParser.decodeFileAccumulating$(this, file, evidence$4);
    }

    public final <A> Either<Error, A> finishDecode(Either<ParsingFailure, Json> input, Decoder<A> decoder) {
        return Parser.finishDecode$((Parser)this, input, decoder);
    }

    public final <A> Validated<NonEmptyList<Error>, A> finishDecodeAccumulating(Either<ParsingFailure, Json> input, Decoder<A> decoder) {
        return Parser.finishDecodeAccumulating$((Parser)this, input, decoder);
    }

    public final <A> Either<Error, A> decode(String input, Decoder<A> evidence$1) {
        return Parser.decode$((Parser)this, (String)input, evidence$1);
    }

    public final <A> Validated<NonEmptyList<Error>, A> decodeAccumulating(String input, Decoder<A> evidence$2) {
        return Parser.decodeAccumulating$((Parser)this, (String)input, evidence$2);
    }

    private void writeJson(Writer w, Json j) {
        JsonGenerator gen = this.jsonGenerator(w);
        this.makeWriter(this.mapper()).writeValue(gen, (Object)j);
        w.flush();
    }

    public final String jacksonPrint(Json json) {
        StringWriter sw = new StringWriter();
        this.writeJson(sw, json);
        return sw.toString();
    }

    public final ByteBuffer jacksonPrintByteBuffer(Json json) {
        package.EnhancedByteArrayOutputStream bytes = new package.EnhancedByteArrayOutputStream();
        this.writeJson(new BufferedWriter(new OutputStreamWriter((OutputStream)bytes, "UTF-8")), json);
        return bytes.toByteBuffer();
    }

    private Json negativeZeroJson() {
        return this.negativeZeroJson;
    }

    public final JsonNode circeToJackson(Json json) {
        return (JsonNode)json.fold((Function0 & Serializable & scala.Serializable)() -> NullNode.instance, (Function1 & Serializable & scala.Serializable)x$1 -> package$.$anonfun$circeToJackson$2(BoxesRunTime.unboxToBoolean((Object)x$1)), (Function1 & Serializable & scala.Serializable)number -> {
            DoubleNode doubleNode;
            Json json = json;
            Json json2 = MODULE$.negativeZeroJson();
            if (!(json != null ? !json.equals(json2) : json2 != null)) {
                doubleNode = DoubleNode.valueOf((double)number.toDouble());
            } else {
                JsonNode jsonNode;
                JsonNumber jsonNumber = number;
                boolean bl = jsonNumber instanceof JsonBiggerDecimal ? true : jsonNumber instanceof JsonBigDecimal;
                if (bl) {
                    jsonNode = (JsonNode)number.toBigDecimal().map((Function1 & Serializable & scala.Serializable)bigDecimal -> DecimalNode.valueOf((BigDecimal)bigDecimal.underlying())).getOrElse((Function0 & Serializable & scala.Serializable)() -> TextNode.valueOf((String)number.toString()));
                } else if (jsonNumber instanceof JsonLong) {
                    JsonLong jsonLong = (JsonLong)jsonNumber;
                    long x = jsonLong.value();
                    jsonNode = LongNode.valueOf((long)x);
                } else if (jsonNumber instanceof JsonDouble) {
                    JsonDouble jsonDouble = (JsonDouble)jsonNumber;
                    double x = jsonDouble.value();
                    jsonNode = DoubleNode.valueOf((double)x);
                } else if (jsonNumber instanceof JsonFloat) {
                    JsonFloat jsonFloat = (JsonFloat)jsonNumber;
                    float x = jsonFloat.value();
                    jsonNode = FloatNode.valueOf((float)x);
                } else if (jsonNumber instanceof JsonDecimal) {
                    TextNode textNode;
                    JsonDecimal jsonDecimal = (JsonDecimal)jsonNumber;
                    String x = jsonDecimal.input();
                    try {
                        textNode = DecimalNode.valueOf((BigDecimal)new BigDecimal(x));
                    }
                    catch (NumberFormatException nfe) {
                        textNode = TextNode.valueOf((String)x);
                    }
                    jsonNode = textNode;
                } else {
                    throw new MatchError((Object)jsonNumber);
                }
                doubleNode = jsonNode;
            }
            return doubleNode;
        }, (Function1 & Serializable & scala.Serializable)x$2 -> TextNode.valueOf((String)x$2), (Function1 & Serializable & scala.Serializable)array -> JsonNodeFactory.instance.arrayNode().addAll((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)array.map((Function1 & Serializable & scala.Serializable)json -> MODULE$.circeToJackson((Json)json), Vector$.MODULE$.canBuildFrom())).asJava()), (Function1 & Serializable & scala.Serializable)obj -> MODULE$.objectNodeSetAll(JsonNodeFactory.instance.objectNode(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)obj.toMap().mapValues((Function1 & Serializable & scala.Serializable)json -> MODULE$.circeToJackson((Json)json)).toMap(Predef$.MODULE$.$conforms())).asJava()));
    }

    public final Json jacksonToCirce(JsonNode node2) {
        JsonNodeType jsonNodeType = node2.getNodeType();
        Json json = JsonNodeType.BOOLEAN.equals(jsonNodeType) ? Json$.MODULE$.fromBoolean(node2.asBoolean()) : (JsonNodeType.STRING.equals(jsonNodeType) ? Json$.MODULE$.fromString(node2.asText()) : (JsonNodeType.NUMBER.equals(jsonNodeType) ? (node2.isFloatingPointNumber() ? Json$.MODULE$.fromBigDecimal(BigDecimal$.MODULE$.javaBigDecimal2bigDecimal(new BigDecimal(node2.asText()))) : Json$.MODULE$.fromBigInt(BigInt$.MODULE$.javaBigInteger2bigInt(node2.bigIntegerValue()))) : (JsonNodeType.ARRAY.equals(jsonNodeType) ? Json$.MODULE$.fromValues(((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(node2.elements()).asScala()).map((Function1 & Serializable & scala.Serializable)node -> MODULE$.jacksonToCirce((JsonNode)node)).toIterable()) : (JsonNodeType.OBJECT.equals(jsonNodeType) ? Json$.MODULE$.fromFields(((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(node2.fields()).asScala()).map((Function1 & Serializable & scala.Serializable)m -> new Tuple2(m.getKey(), (Object)MODULE$.jacksonToCirce((JsonNode)m.getValue()))).toIterable()) : Json$.MODULE$.Null()))));
        return json;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ BooleanNode $anonfun$circeToJackson$2(boolean x$1) {
        return BooleanNode.valueOf((boolean)x$1);
    }

    private package$() {
        MODULE$ = this;
        Parser.$init$((Parser)this);
        JacksonParser.$init$(this);
        JacksonCompat.$init$(this);
        this.negativeZeroJson = Json$.MODULE$.fromDoubleOrNull(-0.0);
    }
}

