/*
 * Decompiled with CFR 0.152.
 */
package io.circe.numbers;

import io.circe.numbers.BiggerDecimal;
import io.circe.numbers.SigAndExp;
import java.math.BigDecimal;
import java.math.BigInteger;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class BiggerDecimal$
implements Serializable {
    public static final BiggerDecimal$ MODULE$;
    private final BigInteger MaxBigIntegerDigits;
    private final BigInteger MaxInt;
    private final BigInteger MinInt;
    private final BigDecimal MaxLong;
    private final BigDecimal MinLong;
    private final BiggerDecimal UnsignedZero;
    private final BiggerDecimal NegativeZero;
    private final String MaxLongString;
    private final String MinLongString;
    private final int FAILED;
    private final int START;
    private final int AFTER_ZERO;
    private final int AFTER_DOT;
    private final int FRACTIONAL;
    private final int AFTER_E;
    private final int AFTER_EXP_SIGN;
    private final int EXPONENT;
    private final int INTEGRAL;

    static {
        new BiggerDecimal$();
    }

    public BigInteger MaxBigIntegerDigits() {
        return this.MaxBigIntegerDigits;
    }

    public BigInteger MaxInt() {
        return this.MaxInt;
    }

    public BigInteger MinInt() {
        return this.MinInt;
    }

    public BigDecimal MaxLong() {
        return this.MaxLong;
    }

    public BigDecimal MinLong() {
        return this.MinLong;
    }

    public BiggerDecimal NegativeZero() {
        return this.NegativeZero;
    }

    private BiggerDecimal fromUnscaledAndScale(BigInteger unscaled, long scale) {
        BiggerDecimal biggerDecimal;
        if (BoxesRunTime.equalsNumNum((Number)unscaled, (Number)BigInteger.ZERO)) {
            biggerDecimal = this.UnsignedZero;
        } else {
            BigInteger current = unscaled;
            long depth = scale;
            BigInteger[] divAndRem = current.divideAndRemainder(BigInteger.TEN);
            while (BoxesRunTime.equalsNumNum((Number)divAndRem[1], (Number)BigInteger.ZERO)) {
                current = divAndRem[0];
                --depth;
                divAndRem = current.divideAndRemainder(BigInteger.TEN);
            }
            biggerDecimal = new SigAndExp(current, BigInteger.valueOf(depth));
        }
        return biggerDecimal;
    }

    public BiggerDecimal fromBigInteger(BigInteger i) {
        return this.fromUnscaledAndScale(i, 0L);
    }

    public BiggerDecimal fromBigDecimal(BigDecimal d) {
        return this.fromUnscaledAndScale(d.unscaledValue(), d.scale());
    }

    public BiggerDecimal fromLong(long d) {
        return this.fromUnscaledAndScale(BigInteger.valueOf(d), 0L);
    }

    public BiggerDecimal fromDoubleUnsafe(double d) {
        return Double.compare(d, -0.0) == 0 ? this.NegativeZero() : this.fromBigDecimal(BigDecimal.valueOf(d));
    }

    public BiggerDecimal fromFloat(float f) {
        return Float.compare(f, -0.0f) == 0 ? this.NegativeZero() : this.fromBigDecimal(new BigDecimal(Float.toString(f)));
    }

    public boolean integralIsValidLong(String s) {
        String bound = s.charAt(0) == '-' ? "-9223372036854775808" : "9223372036854775807";
        return s.length() < bound.length() || s.length() == bound.length() && s.compareTo(bound) <= 0;
    }

    public Option<BiggerDecimal> parseBiggerDecimal(String input) {
        return Option$.MODULE$.apply((Object)this.parseBiggerDecimalUnsafe(input));
    }

    public BiggerDecimal parseBiggerDecimalUnsafe(String input) {
        BiggerDecimal biggerDecimal;
        int len = input.length();
        if (len == 0) {
            biggerDecimal = null;
        } else {
            int state;
            int n;
            int i;
            int zeros = 0;
            int decIndex = -1;
            int expIndex = -1;
            int n2 = i = input.charAt(0) == '-' ? 1 : 0;
            if (i >= len) {
                n = 0;
            } else if (input.charAt(i) != '0') {
                n = 1;
            } else {
                ++i;
                n = state = 2;
            }
            while (i < len && state != 0) {
                char c = input.charAt(i);
                int n3 = state;
                switch (n3) {
                    default: {
                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n3));
                    }
                    case 7: {
                        if (c >= '0' && c <= '9') {
                            state = 7;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 6: {
                        if (c >= '0' && c <= '9') {
                            state = 7;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 4: {
                        if (c == '0') {
                            ++zeros;
                            state = 4;
                            break;
                        }
                        if (c >= '1' && c <= '9') {
                            zeros = 0;
                            state = 4;
                            break;
                        }
                        if (c == 'e' || c == 'E') {
                            state = 5;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 5: {
                        expIndex = i - 1;
                        if (c >= '0' && c <= '9') {
                            state = 7;
                            break;
                        }
                        if (c == '+' || c == '-') {
                            state = 6;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 3: {
                        decIndex = i - 1;
                        if (c == '0') {
                            ++zeros;
                            state = 4;
                            break;
                        }
                        if (c >= '1' && c <= '9') {
                            zeros = 0;
                            state = 4;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 8: {
                        if (c == '0') {
                            ++zeros;
                            state = 8;
                            break;
                        }
                        if (c >= '1' && c <= '9') {
                            zeros = 0;
                            state = 8;
                            break;
                        }
                        if (c == '.') {
                            state = 3;
                            break;
                        }
                        if (c == 'e' || c == 'E') {
                            state = 5;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 2: {
                        if (c == '.') {
                            state = 3;
                            break;
                        }
                        if (c == 'e' || c == 'E') {
                            state = 5;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 1: {
                        state = c >= '1' && c <= '9' ? 8 : 0;
                    }
                }
                ++i;
            }
            if (state == 0 || state == 3 || state == 5 || state == 6) {
                biggerDecimal = null;
            } else {
                String integral;
                String string = decIndex >= 0 ? input.substring(0, decIndex) : (integral = expIndex == -1 ? input : input.substring(0, expIndex));
                String fractional = decIndex == -1 ? "" : (expIndex == -1 ? input.substring(decIndex + 1) : input.substring(decIndex + 1, expIndex));
                String unscaledString = new StringBuilder().append((Object)integral).append((Object)fractional).toString();
                BigInteger unscaled = new BigInteger(unscaledString.substring(0, unscaledString.length() - zeros));
                if (BoxesRunTime.equalsNumNum((Number)unscaled, (Number)BigInteger.ZERO)) {
                    biggerDecimal = input.charAt(0) == '-' ? this.NegativeZero() : this.UnsignedZero;
                } else {
                    BigInteger rescale = BigInteger.valueOf(fractional.length() - zeros);
                    BigInteger scale = expIndex == -1 ? rescale : rescale.subtract(new BigInteger(input.substring(expIndex + 1)));
                    biggerDecimal = new SigAndExp(unscaled, scale);
                }
            }
        }
        return biggerDecimal;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BiggerDecimal$() {
        MODULE$ = this;
        this.MaxBigIntegerDigits = BigInteger.valueOf(262144L);
        this.MaxInt = BigInteger.valueOf(Integer.MAX_VALUE);
        this.MinInt = BigInteger.valueOf(Integer.MIN_VALUE);
        this.MaxLong = new BigDecimal(Long.MAX_VALUE);
        this.MinLong = new BigDecimal(Long.MIN_VALUE);
        this.UnsignedZero = new BiggerDecimal.Zero(){

            public final boolean isNegativeZero() {
                return false;
            }

            public final double toDouble() {
                return 0.0;
            }

            public final float toFloat() {
                return 0.0f;
            }

            public final boolean equals(Object that) {
                BiggerDecimal.Zero zero;
                Object object = that;
                boolean bl = object instanceof BiggerDecimal.Zero ? !(zero = (BiggerDecimal.Zero)object).isNegativeZero() : false;
                return bl;
            }

            public final int hashCode() {
                return ((Object)BoxesRunTime.boxToDouble((double)0.0)).hashCode();
            }

            public final String toString() {
                return "0";
            }
        };
        this.NegativeZero = new BiggerDecimal.Zero(){

            public final boolean isNegativeZero() {
                return true;
            }

            public final double toDouble() {
                return -0.0;
            }

            public final float toFloat() {
                return -0.0f;
            }

            public final boolean equals(Object that) {
                boolean bl;
                Object object = that;
                if (object instanceof BiggerDecimal.Zero) {
                    BiggerDecimal.Zero zero = (BiggerDecimal.Zero)object;
                    bl = zero.isNegativeZero();
                } else {
                    bl = false;
                }
                return bl;
            }

            public final int hashCode() {
                return ((Object)BoxesRunTime.boxToDouble((double)-0.0)).hashCode();
            }

            public final String toString() {
                return "-0";
            }
        };
    }
}

