/*
 * Decompiled with CFR 0.152.
 */
package io.circe.numbers;

import io.circe.numbers.BiggerDecimal;
import io.circe.numbers.SigAndExp;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class BiggerDecimal$
implements Serializable {
    private static final BigInteger MaxBigIntegerDigits;
    private static final BigInteger MaxInt;
    private static final BigInteger MinInt;
    private static final BigDecimal MaxLong;
    private static final BigDecimal MinLong;
    private static final BiggerDecimal UnsignedZero;
    private static final BiggerDecimal NegativeZero;
    public static final BiggerDecimal$ MODULE$;

    private BiggerDecimal$() {
    }

    static {
        MODULE$ = new BiggerDecimal$();
        MaxBigIntegerDigits = BigInteger.valueOf(262144L);
        MaxInt = BigInteger.valueOf(Integer.MAX_VALUE);
        MinInt = BigInteger.valueOf(Integer.MIN_VALUE);
        MaxLong = new BigDecimal(Long.MAX_VALUE);
        MinLong = new BigDecimal(Long.MIN_VALUE);
        UnsignedZero = new BiggerDecimal.Zero(){

            public final boolean isNegativeZero() {
                return false;
            }

            public final double toDouble() {
                return 0.0;
            }

            public final float toFloat() {
                return 0.0f;
            }

            public final boolean equals(Object that) {
                BiggerDecimal.Zero other;
                Object object = that;
                return object instanceof BiggerDecimal.Zero ? !(other = (BiggerDecimal.Zero)object).isNegativeZero() : false;
            }

            public final int hashCode() {
                return BoxesRunTime.boxToDouble((double)0.0).hashCode();
            }

            public final String toString() {
                return "0";
            }
        };
        NegativeZero = new BiggerDecimal.Zero(){

            public final boolean isNegativeZero() {
                return true;
            }

            public final double toDouble() {
                return -0.0;
            }

            public final float toFloat() {
                return -0.0f;
            }

            public final boolean equals(Object that) {
                boolean bl;
                Object object = that;
                if (object instanceof BiggerDecimal.Zero) {
                    BiggerDecimal.Zero other = (BiggerDecimal.Zero)object;
                    bl = other.isNegativeZero();
                } else {
                    bl = false;
                }
                return bl;
            }

            public final int hashCode() {
                return BoxesRunTime.boxToDouble((double)-0.0).hashCode();
            }

            public final String toString() {
                return "-0";
            }
        };
        String MaxLongString = "9223372036854775807";
        String MinLongString = "-9223372036854775808";
        boolean FAILED = false;
        boolean START = true;
        int AFTER_ZERO = 2;
        int AFTER_DOT = 3;
        int FRACTIONAL = 4;
        int AFTER_E = 5;
        int AFTER_EXP_SIGN = 6;
        int EXPONENT = 7;
        int INTEGRAL = 8;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BiggerDecimal$.class);
    }

    public BigInteger MaxBigIntegerDigits() {
        return MaxBigIntegerDigits;
    }

    public BigInteger MaxInt() {
        return MaxInt;
    }

    public BigInteger MinInt() {
        return MinInt;
    }

    public BigDecimal MaxLong() {
        return MaxLong;
    }

    public BigDecimal MinLong() {
        return MinLong;
    }

    public BiggerDecimal NegativeZero() {
        return NegativeZero;
    }

    private BiggerDecimal fromUnscaledAndScale(BigInteger unscaled, long scale) {
        BiggerDecimal biggerDecimal;
        if (BoxesRunTime.equals((Object)unscaled, (Object)BigInteger.ZERO)) {
            biggerDecimal = UnsignedZero;
        } else {
            BigInteger current = unscaled;
            long depth = scale;
            BigInteger[] divAndRem = current.divideAndRemainder(BigInteger.TEN);
            while (BoxesRunTime.equals((Object)divAndRem[1], (Object)BigInteger.ZERO)) {
                current = divAndRem[0];
                --depth;
                divAndRem = current.divideAndRemainder(BigInteger.TEN);
            }
            biggerDecimal = new SigAndExp(current, BigInteger.valueOf(depth));
        }
        return biggerDecimal;
    }

    public BiggerDecimal fromBigInteger(BigInteger i) {
        return this.fromUnscaledAndScale(i, 0L);
    }

    public BiggerDecimal fromBigDecimal(BigDecimal d) {
        return this.fromUnscaledAndScale(d.unscaledValue(), d.scale());
    }

    public BiggerDecimal fromLong(long d) {
        return this.fromUnscaledAndScale(BigInteger.valueOf(d), 0L);
    }

    public BiggerDecimal fromDoubleUnsafe(double d) {
        return Double.compare(d, -0.0) == 0 ? this.NegativeZero() : this.fromBigDecimal(BigDecimal.valueOf(d));
    }

    public BiggerDecimal fromFloat(float f) {
        return Float.compare(f, -0.0f) == 0 ? this.NegativeZero() : this.fromBigDecimal(new BigDecimal(Float.toString(f)));
    }

    public boolean integralIsValidLong(String s) {
        String bound = s.charAt(0) == '-' ? "-9223372036854775808" : "9223372036854775807";
        return s.length() < bound.length() || s.length() == bound.length() && s.compareTo(bound) <= 0;
    }

    public Option<BiggerDecimal> parseBiggerDecimal(String input) {
        return Option$.MODULE$.apply((Object)this.parseBiggerDecimalUnsafe(input));
    }

    public BiggerDecimal parseBiggerDecimalUnsafe(String input) {
        BiggerDecimal biggerDecimal;
        int len = input.length();
        if (len == 0) {
            biggerDecimal = null;
        } else {
            int state;
            int n;
            int i;
            int zeros = 0;
            int decIndex = -1;
            int expIndex = -1;
            int n2 = i = input.charAt(0) == '-' ? 1 : 0;
            if (i >= len) {
                n = 0;
            } else if (input.charAt(i) != '0') {
                n = 1;
            } else {
                ++i;
                n = state = 2;
            }
            while (i < len && state != 0) {
                char c = input.charAt(i);
                int n3 = state;
                switch (n3) {
                    case 1: {
                        if (c >= '1' && c <= '9') {
                            state = 8;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 2: {
                        if (c == '.') {
                            state = 3;
                            break;
                        }
                        if (c == 'e' || c == 'E') {
                            state = 5;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 8: {
                        if (c == '0') {
                            ++zeros;
                            state = 8;
                            break;
                        }
                        if (c >= '1' && c <= '9') {
                            zeros = 0;
                            state = 8;
                            break;
                        }
                        if (c == '.') {
                            state = 3;
                            break;
                        }
                        if (c == 'e' || c == 'E') {
                            state = 5;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 3: {
                        decIndex = i - 1;
                        if (c == '0') {
                            ++zeros;
                            state = 4;
                            break;
                        }
                        if (c >= '1' && c <= '9') {
                            zeros = 0;
                            state = 4;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 5: {
                        expIndex = i - 1;
                        if (c >= '0' && c <= '9') {
                            state = 7;
                            break;
                        }
                        if (c == '+' || c == '-') {
                            state = 6;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 4: {
                        if (c == '0') {
                            ++zeros;
                            state = 4;
                            break;
                        }
                        if (c >= '1' && c <= '9') {
                            zeros = 0;
                            state = 4;
                            break;
                        }
                        if (c == 'e' || c == 'E') {
                            state = 5;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 6: {
                        if (c >= '0' && c <= '9') {
                            state = 7;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    case 7: {
                        if (c >= '0' && c <= '9') {
                            state = 7;
                            break;
                        }
                        state = 0;
                        break;
                    }
                    default: {
                        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n3));
                    }
                }
                ++i;
            }
            if (state == 0 || state == 3 || state == 5 || state == 6) {
                biggerDecimal = null;
            } else {
                String integral;
                String string = decIndex >= 0 ? input.substring(0, decIndex) : (integral = expIndex == -1 ? input : input.substring(0, expIndex));
                String fractional = decIndex == -1 ? "" : (expIndex == -1 ? input.substring(decIndex + 1) : input.substring(decIndex + 1, expIndex));
                String unscaledString = integral + fractional;
                BigInteger unscaled = new BigInteger(unscaledString.substring(0, unscaledString.length() - zeros));
                if (BoxesRunTime.equals((Object)unscaled, (Object)BigInteger.ZERO)) {
                    biggerDecimal = input.charAt(0) == '-' ? this.NegativeZero() : UnsignedZero;
                } else {
                    BigInteger rescale = BigInteger.valueOf(fractional.length() - zeros);
                    BigInteger scale = expIndex == -1 ? rescale : rescale.subtract(new BigInteger(input.substring(expIndex + 1)));
                    biggerDecimal = new SigAndExp(unscaled, scale);
                }
            }
        }
        return biggerDecimal;
    }
}

