/*
 * Decompiled with CFR 0.152.
 */
package io.circe.numbers;

import io.circe.numbers.BiggerDecimal;
import io.circe.numbers.BiggerDecimal$;
import java.math.BigDecimal;
import java.math.BigInteger;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.runtime.BoxesRunTime;

public final class SigAndExp
extends BiggerDecimal {
    private final BigInteger unscaled;
    private final BigInteger scale;

    public SigAndExp(BigInteger unscaled, BigInteger scale) {
        this.unscaled = unscaled;
        this.scale = scale;
    }

    public BigInteger unscaled() {
        return this.unscaled;
    }

    public BigInteger scale() {
        return this.scale;
    }

    @Override
    public boolean isWhole() {
        return this.scale().signum() < 1;
    }

    @Override
    public boolean isNegativeZero() {
        return false;
    }

    @Override
    public int signum() {
        return this.unscaled().signum();
    }

    @Override
    public Option<BigDecimal> toBigDecimal() {
        return this.scale().compareTo(BiggerDecimal$.MODULE$.MaxInt()) <= 0 && this.scale().compareTo(BiggerDecimal$.MODULE$.MinInt()) >= 0 ? Some$.MODULE$.apply((Object)new BigDecimal(this.unscaled(), this.scale().intValue())) : None$.MODULE$;
    }

    @Override
    public Option<BigInteger> toBigIntegerWithMaxDigits(BigInteger maxDigits) {
        BigInteger digits;
        return !this.isWhole() ? None$.MODULE$ : ((digits = BigInteger.valueOf(this.unscaled().abs().toString().length()).subtract(this.scale())).compareTo(maxDigits) > 0 ? None$.MODULE$ : Some$.MODULE$.apply((Object)new BigDecimal(this.unscaled(), this.scale().intValue()).toBigInteger()));
    }

    @Override
    public double toDouble() {
        return this.scale().compareTo(BiggerDecimal$.MODULE$.MaxInt()) <= 0 && this.scale().compareTo(BiggerDecimal$.MODULE$.MinInt()) >= 0 ? new BigDecimal(this.unscaled(), this.scale().intValue()).doubleValue() : (this.scale().signum() == 1 ? 0.0 : Double.POSITIVE_INFINITY) * (double)this.unscaled().signum();
    }

    @Override
    public float toFloat() {
        return this.scale().compareTo(BiggerDecimal$.MODULE$.MaxInt()) <= 0 && this.scale().compareTo(BiggerDecimal$.MODULE$.MinInt()) >= 0 ? new BigDecimal(this.unscaled(), this.scale().intValue()).floatValue() : (this.scale().signum() == 1 ? 0.0f : Float.POSITIVE_INFINITY) * (float)this.unscaled().signum();
    }

    @Override
    public Option<Object> toLong() {
        Object object;
        if (!this.isWhole()) {
            object = None$.MODULE$;
        } else {
            Option<BigInteger> option = this.toBigInteger();
            if (option instanceof Some) {
                BigInteger i = (BigInteger)((Some)option).value();
                long asLong = i.longValue();
                object = BoxesRunTime.equals((Object)BigInteger.valueOf(asLong), (Object)i) ? Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)asLong)) : None$.MODULE$;
            } else if (None$.MODULE$.equals(option)) {
                object = None$.MODULE$;
            } else {
                throw new MatchError(option);
            }
        }
        return object;
    }

    public boolean equals(Object that) {
        boolean bl;
        Object object = that;
        if (object instanceof SigAndExp) {
            SigAndExp other = (SigAndExp)object;
            bl = BoxesRunTime.equals((Object)this.unscaled(), (Object)other.unscaled()) && BoxesRunTime.equals((Object)this.scale(), (Object)other.scale());
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.scale().hashCode() + this.unscaled().hashCode();
    }

    public String toString() {
        return BoxesRunTime.equals((Object)this.scale(), (Object)BigInteger.ZERO) ? this.unscaled().toString() : "" + this.unscaled() + "e" + this.scale().negate();
    }

    @Override
    public void appendToStringBuilder(StringBuilder builder) {
        builder.append(this.unscaled());
        if (!BoxesRunTime.equals((Object)this.scale(), (Object)BigInteger.ZERO)) {
            builder.append('e');
            builder.append(this.scale().negate());
        }
    }
}

