/*
 * Decompiled with CFR 0.152.
 */
package io.circe.numbers;

import io.circe.numbers.BiggerDecimal;
import io.circe.numbers.SigAndExp;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class BiggerDecimal$
implements Serializable {
    private static final BigInteger MaxBigIntegerDigits;
    private static final BigInteger MaxInt;
    private static final BigInteger MinInt;
    private static final BigDecimal MaxLong;
    private static final BigDecimal MinLong;
    private static final BiggerDecimal UnsignedZero;
    private static final BiggerDecimal NegativeZero;
    public static final BiggerDecimal$ MODULE$;

    private BiggerDecimal$() {
    }

    static {
        MODULE$ = new BiggerDecimal$();
        MaxBigIntegerDigits = BigInteger.valueOf(262144L);
        MaxInt = BigInteger.valueOf(Integer.MAX_VALUE);
        MinInt = BigInteger.valueOf(Integer.MIN_VALUE);
        MaxLong = new BigDecimal(Long.MAX_VALUE);
        MinLong = new BigDecimal(Long.MIN_VALUE);
        UnsignedZero = new BiggerDecimal.Zero(){

            public final boolean isNegativeZero() {
                return false;
            }

            public final double toDouble() {
                return 0.0;
            }

            public final float toFloat() {
                return 0.0f;
            }

            public final boolean equals(Object that) {
                Object object = that;
                if (object instanceof BiggerDecimal.Zero) {
                    BiggerDecimal.Zero other = (BiggerDecimal.Zero)object;
                    return !other.isNegativeZero();
                }
                return false;
            }

            public final int hashCode() {
                return BoxesRunTime.boxToDouble((double)0.0).hashCode();
            }

            public final String toString() {
                return "0";
            }
        };
        NegativeZero = new BiggerDecimal.Zero(){

            public final boolean isNegativeZero() {
                return true;
            }

            public final double toDouble() {
                return -0.0;
            }

            public final float toFloat() {
                return -0.0f;
            }

            public final boolean equals(Object that) {
                Object object = that;
                if (object instanceof BiggerDecimal.Zero) {
                    BiggerDecimal.Zero other = (BiggerDecimal.Zero)object;
                    return other.isNegativeZero();
                }
                return false;
            }

            public final int hashCode() {
                return BoxesRunTime.boxToDouble((double)-0.0).hashCode();
            }

            public final String toString() {
                return "-0";
            }
        };
        String MaxLongString = "9223372036854775807";
        String MinLongString = "-9223372036854775808";
        boolean FAILED = false;
        boolean AFTER_DOT = true;
        int FRACTIONAL = 2;
        int AFTER_E = 3;
        int AFTER_EXP_SIGN = 4;
        int EXPONENT = 5;
        int INTEGRAL = 6;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BiggerDecimal$.class);
    }

    public BigInteger MaxBigIntegerDigits() {
        return MaxBigIntegerDigits;
    }

    public BigInteger MaxInt() {
        return MaxInt;
    }

    public BigInteger MinInt() {
        return MinInt;
    }

    public BigDecimal MaxLong() {
        return MaxLong;
    }

    public BigDecimal MinLong() {
        return MinLong;
    }

    public BiggerDecimal NegativeZero() {
        return NegativeZero;
    }

    private BiggerDecimal fromUnscaledAndScale(BigInteger unscaled, long scale) {
        if (BoxesRunTime.equals((Object)unscaled, (Object)BigInteger.ZERO)) {
            return UnsignedZero;
        }
        BigInteger current = unscaled;
        long depth = scale;
        BigInteger[] divAndRem = current.divideAndRemainder(BigInteger.TEN);
        while (BoxesRunTime.equals((Object)divAndRem[1], (Object)BigInteger.ZERO)) {
            current = divAndRem[0];
            --depth;
            divAndRem = current.divideAndRemainder(BigInteger.TEN);
        }
        return new SigAndExp(current, BigInteger.valueOf(depth));
    }

    public BiggerDecimal fromBigInteger(BigInteger i) {
        return this.fromUnscaledAndScale(i, 0L);
    }

    public BiggerDecimal fromBigDecimal(BigDecimal d) {
        return this.fromUnscaledAndScale(d.unscaledValue(), d.scale());
    }

    public BiggerDecimal fromLong(long d) {
        return this.fromUnscaledAndScale(BigInteger.valueOf(d), 0L);
    }

    public BiggerDecimal fromDoubleUnsafe(double d) {
        if (Double.compare(d, -0.0) == 0) {
            return this.NegativeZero();
        }
        return this.fromBigDecimal(BigDecimal.valueOf(d));
    }

    public BiggerDecimal fromFloat(float f) {
        if (Float.compare(f, -0.0f) == 0) {
            return this.NegativeZero();
        }
        return this.fromBigDecimal(new BigDecimal(Float.toString(f)));
    }

    public boolean integralIsValidLong(String s) {
        String bound = s.charAt(0) == '-' ? "-9223372036854775808" : "9223372036854775807";
        return s.length() < bound.length() || s.length() == bound.length() && s.compareTo(bound) <= 0;
    }

    public Option<BiggerDecimal> parseBiggerDecimal(String input) {
        return Option$.MODULE$.apply((Object)this.parseBiggerDecimalUnsafe(input));
    }

    public BiggerDecimal parseBiggerDecimalUnsafe(String input) {
        String integral;
        int i;
        int len = input.length();
        if (len == 0) {
            return null;
        }
        int zeros = 0;
        int decIndex = -1;
        int expIndex = -1;
        boolean parsedNonZeroIntegralDigit = false;
        if (i >= len) {
            return null;
        }
        int state = 6;
        block8: for (i = input.charAt(0) == '-' ? 1 : 0; i < len && state != 0; ++i) {
            char c = input.charAt(i);
            int n = state;
            switch (n) {
                case 6: {
                    if (c == '0') {
                        if (!parsedNonZeroIntegralDigit) continue block8;
                        ++zeros;
                        continue block8;
                    }
                    if (c >= '1' && c <= '9') {
                        parsedNonZeroIntegralDigit = true;
                        zeros = 0;
                        continue block8;
                    }
                    if (c == '.') {
                        state = 1;
                        continue block8;
                    }
                    if (c == 'e' || c == 'E') {
                        state = 3;
                        continue block8;
                    }
                    state = 0;
                    continue block8;
                }
                case 1: {
                    decIndex = i - 1;
                    if (c == '0') {
                        ++zeros;
                        state = 2;
                        continue block8;
                    }
                    if (c >= '1' && c <= '9') {
                        zeros = 0;
                        state = 2;
                        continue block8;
                    }
                    state = 0;
                    continue block8;
                }
                case 3: {
                    expIndex = i - 1;
                    if (c >= '0' && c <= '9') {
                        state = 5;
                        continue block8;
                    }
                    if (c == '+' || c == '-') {
                        state = 4;
                        continue block8;
                    }
                    state = 0;
                    continue block8;
                }
                case 2: {
                    if (c == '0') {
                        ++zeros;
                        state = 2;
                        continue block8;
                    }
                    if (c >= '1' && c <= '9') {
                        zeros = 0;
                        state = 2;
                        continue block8;
                    }
                    if (c == 'e' || c == 'E') {
                        state = 3;
                        continue block8;
                    }
                    state = 0;
                    continue block8;
                }
                case 4: {
                    if (c >= '0' && c <= '9') {
                        state = 5;
                        continue block8;
                    }
                    state = 0;
                    continue block8;
                }
                case 5: {
                    if (c >= '0' && c <= '9') {
                        state = 5;
                        continue block8;
                    }
                    state = 0;
                    continue block8;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
            }
        }
        if (state == 0 || state == 1 || state == 3 || state == 4) {
            return null;
        }
        String string = decIndex >= 0 ? input.substring(0, decIndex) : (integral = expIndex == -1 ? input : input.substring(0, expIndex));
        String fractional = decIndex == -1 ? "" : (expIndex == -1 ? input.substring(decIndex + 1) : input.substring(decIndex + 1, expIndex));
        String unscaledString = new StringBuilder(0).append(integral).append(fractional).toString();
        BigInteger unscaled = new BigInteger(unscaledString.substring(0, unscaledString.length() - zeros));
        if (BoxesRunTime.equals((Object)unscaled, (Object)BigInteger.ZERO)) {
            if (input.charAt(0) == '-') {
                return this.NegativeZero();
            }
            return UnsignedZero;
        }
        BigInteger rescale = BigInteger.valueOf(fractional.length() - zeros);
        BigInteger scale = expIndex == -1 ? rescale : rescale.subtract(new BigInteger(input.substring(expIndex + 1)));
        return new SigAndExp(unscaled, scale);
    }
}

