/*
 * Decompiled with CFR 0.152.
 */
package io.circe.optics;

import cats.Applicative;
import cats.Functor;
import cats.instances.package;
import cats.syntax.package;
import io.circe.Json;
import io.circe.Json$;
import io.circe.JsonNumber;
import io.circe.JsonNumber$;
import io.circe.JsonObject;
import io.circe.optics.JsonNumberOptics$;
import io.circe.optics.JsonObjectOptics$;
import io.circe.optics.JsonOptics;
import monocle.PPrism;
import monocle.PTraversal;
import monocle.Prism$;
import monocle.function.Each$;
import monocle.function.Plated;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.immutable.Vector;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class JsonOptics$class {
    public static final PPrism jsonNull(JsonOptics $this) {
        return Prism$.MODULE$.apply((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Option<BoxedUnit> apply(Json j) {
                return j.isNull() ? new Some((Object)BoxedUnit.UNIT) : None$.MODULE$;
            }
        }, (Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Json apply(BoxedUnit x$1) {
                return Json$.MODULE$.Null();
            }
        });
    }

    public static final PPrism jsonBoolean(JsonOptics $this) {
        return Prism$.MODULE$.apply((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Option<Object> apply(Json x$2) {
                return x$2.asBoolean();
            }
        }, (Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Json apply(boolean value) {
                return Json$.MODULE$.fromBoolean(value);
            }
        });
    }

    public static final PPrism jsonBigDecimal(JsonOptics $this) {
        return $this.jsonNumber().composePrism(JsonNumberOptics$.MODULE$.jsonNumberBigDecimal());
    }

    public static final PPrism jsonBigInt(JsonOptics $this) {
        return $this.jsonNumber().composePrism(JsonNumberOptics$.MODULE$.jsonNumberBigInt());
    }

    public static final PPrism jsonLong(JsonOptics $this) {
        return $this.jsonNumber().composePrism(JsonNumberOptics$.MODULE$.jsonNumberLong());
    }

    public static final PPrism jsonInt(JsonOptics $this) {
        return $this.jsonNumber().composePrism(JsonNumberOptics$.MODULE$.jsonNumberInt());
    }

    public static final PPrism jsonShort(JsonOptics $this) {
        return $this.jsonNumber().composePrism(JsonNumberOptics$.MODULE$.jsonNumberShort());
    }

    public static final PPrism jsonByte(JsonOptics $this) {
        return $this.jsonNumber().composePrism(JsonNumberOptics$.MODULE$.jsonNumberByte());
    }

    public static final PPrism jsonString(JsonOptics $this) {
        return Prism$.MODULE$.apply((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(Json x$3) {
                return x$3.asString();
            }
        }, (Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Json apply(String value) {
                return Json$.MODULE$.fromString(value);
            }
        });
    }

    public static final PPrism jsonNumber(JsonOptics $this) {
        return Prism$.MODULE$.apply((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Option<JsonNumber> apply(Json x$4) {
                return x$4.asNumber();
            }
        }, (Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Json apply(JsonNumber value) {
                return Json$.MODULE$.fromJsonNumber(value);
            }
        });
    }

    public static final PPrism jsonObject(JsonOptics $this) {
        return Prism$.MODULE$.apply((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Option<JsonObject> apply(Json x$5) {
                return x$5.asObject();
            }
        }, (Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Json apply(JsonObject value) {
                return Json$.MODULE$.fromJsonObject(value);
            }
        });
    }

    public static final PPrism jsonArray(JsonOptics $this) {
        return Prism$.MODULE$.apply((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Option<Vector<Json>> apply(Json x$6) {
                return x$6.asArray();
            }
        }, (Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Json apply(Iterable<Json> values) {
                return Json$.MODULE$.fromValues(values);
            }
        });
    }

    public static final PPrism jsonDouble(JsonOptics $this) {
        return Prism$.MODULE$.apply((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Option<Object> apply(Json x$7) {
                return (Option)x$7.foldWith((Json.Folder)new Json.Folder<Option<Object>>(this){

                    public Option<Object> onNull() {
                        return new Some((Object)BoxesRunTime.boxToDouble((double)Double.NaN));
                    }

                    public Option<Object> onBoolean(boolean value) {
                        return None$.MODULE$;
                    }

                    public Option<Object> onNumber(JsonNumber value) {
                        double d = value.toDouble();
                        return Double.isInfinite(d) ? None$.MODULE$ : (Json$.MODULE$.fromDouble(d).flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Option<JsonNumber> apply(Json x$8) {
                                return x$8.asNumber();
                            }
                        }).exists((Function1)new Serializable(this, value){
                            public static final long serialVersionUID = 0L;
                            private final JsonNumber value$1;

                            public final boolean apply(JsonNumber x$9) {
                                return JsonNumber$.MODULE$.eqJsonNumber().eqv((Object)this.value$1, (Object)x$9);
                            }
                            {
                                this.value$1 = value$1;
                            }
                        }) ? new Some((Object)BoxesRunTime.boxToDouble((double)d)) : None$.MODULE$);
                    }

                    public Option<Object> onString(String value) {
                        return None$.MODULE$;
                    }

                    public Option<Object> onArray(Vector<Json> value) {
                        return None$.MODULE$;
                    }

                    public Option<Object> onObject(JsonObject value) {
                        return None$.MODULE$;
                    }
                });
            }
        }, (Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Json apply(double value) {
                return Json$.MODULE$.fromDoubleOrNull(value);
            }
        });
    }

    public static final PTraversal jsonDescendants(JsonOptics $this) {
        return new PTraversal<Json, Json, Json, Json>($this){

            public <F> F modifyF(Function1<Json, F> f, Json s, Applicative<F> F) {
                return (F)s.fold((Function0)new Serializable(this, s, F){
                    public static final long serialVersionUID = 0L;
                    private final Json s$1;
                    private final Applicative F$1;

                    public final F apply() {
                        return (F)this.F$1.pure((Object)this.s$1);
                    }
                    {
                        this.s$1 = s$1;
                        this.F$1 = F$1;
                    }
                }, (Function1)new Serializable(this, s, F){
                    public static final long serialVersionUID = 0L;
                    private final Json s$1;
                    private final Applicative F$1;

                    public final F apply(boolean x$10) {
                        return (F)this.F$1.pure((Object)this.s$1);
                    }
                    {
                        this.s$1 = s$1;
                        this.F$1 = F$1;
                    }
                }, (Function1)new Serializable(this, s, F){
                    public static final long serialVersionUID = 0L;
                    private final Json s$1;
                    private final Applicative F$1;

                    public final F apply(JsonNumber x$11) {
                        return (F)this.F$1.pure((Object)this.s$1);
                    }
                    {
                        this.s$1 = s$1;
                        this.F$1 = F$1;
                    }
                }, (Function1)new Serializable(this, s, F){
                    public static final long serialVersionUID = 0L;
                    private final Json s$1;
                    private final Applicative F$1;

                    public final F apply(String x$12) {
                        return (F)this.F$1.pure((Object)this.s$1);
                    }
                    {
                        this.s$1 = s$1;
                        this.F$1 = F$1;
                    }
                }, (Function1)new Serializable(this, f, F){
                    public static final long serialVersionUID = 0L;
                    private final Function1 f$1;
                    private final Applicative F$1;

                    public final F apply(Vector<Json> arr) {
                        return (F)this.F$1.map(Each$.MODULE$.each(Each$.MODULE$.vectorEach()).modifyF(this.f$1, arr, this.F$1), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Json apply(Vector<Json> x$13) {
                                return Json$.MODULE$.arr(x$13);
                            }
                        });
                    }
                    {
                        this.f$1 = f$1;
                        this.F$1 = F$1;
                    }
                }, (Function1)new Serializable(this, f, F){
                    public static final long serialVersionUID = 0L;
                    private final Function1 f$1;
                    private final Applicative F$1;

                    public final F apply(JsonObject obj) {
                        return (F)this.F$1.map(Each$.MODULE$.each(JsonObjectOptics$.MODULE$.jsonObjectEach()).modifyF(this.f$1, (Object)obj, this.F$1), (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Json apply(JsonObject value) {
                                return Json$.MODULE$.fromJsonObject(value);
                            }
                        });
                    }
                    {
                        this.f$1 = f$1;
                        this.F$1 = F$1;
                    }
                });
            }
        };
    }

    public static final Plated jsonPlated(JsonOptics $this) {
        return new Plated<Json>($this){
            private final PTraversal<Json, Json, Json, Json> plate;

            public PTraversal<Json, Json, Json, Json> plate() {
                return this.plate;
            }
            {
                this.plate = new PTraversal<Json, Json, Json, Json>(this){

                    public <F> F modifyF(Function1<Json, F> f, Json a, Applicative<F> F) {
                        return (F)a.fold((Function0)new Serializable(this, a, F){
                            public static final long serialVersionUID = 0L;
                            private final Json a$1;
                            private final Applicative F$2;

                            public final F apply() {
                                return (F)this.F$2.pure((Object)this.a$1);
                            }
                            {
                                this.a$1 = a$1;
                                this.F$2 = F$2;
                            }
                        }, (Function1)new Serializable(this, F){
                            public static final long serialVersionUID = 0L;
                            private final Applicative F$2;

                            public final F apply(boolean b) {
                                return (F)this.F$2.pure((Object)Json$.MODULE$.fromBoolean(b));
                            }
                            {
                                this.F$2 = F$2;
                            }
                        }, (Function1)new Serializable(this, F){
                            public static final long serialVersionUID = 0L;
                            private final Applicative F$2;

                            public final F apply(JsonNumber n) {
                                return (F)this.F$2.pure((Object)Json$.MODULE$.fromJsonNumber(n));
                            }
                            {
                                this.F$2 = F$2;
                            }
                        }, (Function1)new Serializable(this, F){
                            public static final long serialVersionUID = 0L;
                            private final Applicative F$2;

                            public final F apply(String s) {
                                return (F)this.F$2.pure((Object)Json$.MODULE$.fromString(s));
                            }
                            {
                                this.F$2 = F$2;
                            }
                        }, (Function1)new Serializable(this, f, F){
                            public static final long serialVersionUID = 0L;
                            private final Function1 f$2;
                            private final Applicative F$2;

                            public final F apply(Vector<Json> x$14) {
                                return (F)package.functor$.MODULE$.toFunctorOps(package.traverse$.MODULE$.toTraverseOps(x$14, package.vector$.MODULE$.catsStdInstancesForVector()).traverse(this.f$2, this.F$2), (Functor)this.F$2).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Json apply(Iterable<Json> values) {
                                        return Json$.MODULE$.fromValues(values);
                                    }
                                });
                            }
                            {
                                this.f$2 = f$2;
                                this.F$2 = F$2;
                            }
                        }, (Function1)new Serializable(this, f, F){
                            public static final long serialVersionUID = 0L;
                            private final Function1 f$2;
                            private final Applicative F$2;

                            public final F apply(JsonObject x$15) {
                                return (F)package.functor$.MODULE$.toFunctorOps(x$15.traverse(this.f$2, this.F$2), (Functor)this.F$2).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Json apply(JsonObject value) {
                                        return Json$.MODULE$.fromJsonObject(value);
                                    }
                                });
                            }
                            {
                                this.f$2 = f$2;
                                this.F$2 = F$2;
                            }
                        });
                    }
                };
            }
        };
    }

    public static void $init$(JsonOptics $this) {
    }
}

