/*
 * Decompiled with CFR 0.152.
 */
package io.circe.yaml.v12;

import io.circe.Json;
import io.circe.JsonNumber;
import io.circe.JsonObject;
import io.circe.yaml.common.Printer;
import io.circe.yaml.v12.PrinterImpl$;
import io.circe.yaml.v12.package$;
import io.circe.yaml.v12.package$StringStyleOps$;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.List;
import org.snakeyaml.engine.v2.api.DumpSettings;
import org.snakeyaml.engine.v2.api.StreamDataWriter;
import org.snakeyaml.engine.v2.common.FlowStyle;
import org.snakeyaml.engine.v2.common.ScalarStyle;
import org.snakeyaml.engine.v2.emitter.Emitable;
import org.snakeyaml.engine.v2.emitter.Emitter;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.ScalarNode;
import org.snakeyaml.engine.v2.nodes.SequenceNode;
import org.snakeyaml.engine.v2.nodes.Tag;
import org.snakeyaml.engine.v2.serializer.Serializer;
import scala.Function1;
import scala.None$;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;

public class PrinterImpl
implements Printer {
    private final Printer.StringStyle stringStyle;
    private final boolean preserveOrder;
    private final boolean dropNullKeys;
    private final Printer.FlowStyle mappingStyle;
    private final Printer.FlowStyle sequenceStyle;
    private final DumpSettings options;

    public PrinterImpl(Printer.StringStyle stringStyle, boolean preserveOrder, boolean dropNullKeys, Printer.FlowStyle mappingStyle, Printer.FlowStyle sequenceStyle, DumpSettings options) {
        this.stringStyle = stringStyle;
        this.preserveOrder = preserveOrder;
        this.dropNullKeys = dropNullKeys;
        this.mappingStyle = mappingStyle;
        this.sequenceStyle = sequenceStyle;
        this.options = options;
    }

    public String pretty(Json json) {
        StreamToStringWriter writer = new StreamToStringWriter();
        Serializer serializer = new Serializer(this.options, (Emitable)new Emitter(this.options, (StreamDataWriter)writer));
        serializer.emitStreamStart();
        serializer.serializeDocument(this.jsonToYaml(json));
        serializer.emitStreamEnd();
        return writer.toString();
    }

    private boolean isBad(String s) {
        return s.indexOf(133) >= 0 || s.indexOf(65279) >= 0;
    }

    private boolean hasNewline(String s) {
        return s.indexOf(10) >= 0;
    }

    private ScalarStyle scalarStyle(String value) {
        if (this.isBad(value)) {
            return ScalarStyle.DOUBLE_QUOTED;
        }
        return ScalarStyle.PLAIN;
    }

    private ScalarStyle stringScalarStyle(String value) {
        if (this.isBad(value)) {
            return ScalarStyle.DOUBLE_QUOTED;
        }
        Printer.StringStyle stringStyle = this.stringStyle;
        Printer.StringStyle$.Plain$ plain$ = Printer.StringStyle$.Plain$.MODULE$;
        if (!(stringStyle != null ? !stringStyle.equals(plain$) : plain$ != null) && this.hasNewline(value)) {
            return ScalarStyle.LITERAL;
        }
        return package$StringStyleOps$.MODULE$.toScalarStyle$extension(package$.MODULE$.StringStyleOps(this.stringStyle));
    }

    private ScalarNode scalarNode(Tag tag, String value) {
        return new ScalarNode(tag, value, this.scalarStyle(value));
    }

    private ScalarNode stringNode(String value) {
        return new ScalarNode(Tag.STR, value, this.stringScalarStyle(value));
    }

    private ScalarNode keyNode(String value) {
        return new ScalarNode(Tag.STR, value, this.scalarStyle(value));
    }

    private Node jsonToYaml(Json json) {
        return (Node)json.fold(this::jsonToYaml$$anonfun$1, (Function1 & Serializable)bool -> this.jsonToYaml$$anonfun$2(BoxesRunTime.unboxToBoolean((Object)bool)), (Function1 & Serializable)number -> this.scalarNode(PrinterImpl$.MODULE$.io$circe$yaml$v12$PrinterImpl$$$numberTag((JsonNumber)number), number.toString()), (Function1 & Serializable)str -> this.stringNode((String)str), (Function1 & Serializable)arr -> {
            Printer.FlowStyle flowStyle = this.sequenceStyle;
            Printer.FlowStyle$.Flow$ flow$ = Printer.FlowStyle$.Flow$.MODULE$;
            return new SequenceNode(Tag.SEQ, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)arr.map((Function1 & Serializable)json -> this.jsonToYaml((Json)json))).asJava(), !(flowStyle != null ? !flowStyle.equals(flow$) : flow$ != null) ? FlowStyle.FLOW : FlowStyle.BLOCK);
        }, (Function1 & Serializable)obj -> this.convertObject$1((JsonObject)obj));
    }

    private final MappingNode convertObject$1(JsonObject obj) {
        Iterable fields = this.preserveOrder ? obj.keys() : obj.keys().toSet();
        Map m = obj.toMap();
        Iterable childNodes = (Iterable)fields.flatMap((Function1 & Serializable)key -> {
            Json value = (Json)m.apply(key);
            if (!this.dropNullKeys || !value.isNull()) {
                return Some$.MODULE$.apply((Object)new NodeTuple((Node)this.keyNode((String)key), this.jsonToYaml(value)));
            }
            return None$.MODULE$;
        });
        Printer.FlowStyle flowStyle = this.mappingStyle;
        Printer.FlowStyle$.Flow$ flow$ = Printer.FlowStyle$.Flow$.MODULE$;
        return new MappingNode(Tag.MAP, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)childNodes.toList()).asJava(), !(flowStyle != null ? !flowStyle.equals(flow$) : flow$ != null) ? FlowStyle.FLOW : FlowStyle.BLOCK);
    }

    private final Node jsonToYaml$$anonfun$1() {
        return this.scalarNode(Tag.NULL, "null");
    }

    private final /* synthetic */ Node jsonToYaml$$anonfun$2(boolean bool) {
        return this.scalarNode(Tag.BOOL, BoxesRunTime.boxToBoolean((boolean)bool).toString());
    }

    public static class StreamToStringWriter
    extends StringWriter
    implements StreamDataWriter {
        @Override
        public void flush() {
            super.flush();
        }
    }
}

