/*
 * Decompiled with CFR 0.152.
 */
package io.circe.yaml;

import io.circe.Json;
import io.circe.JsonNumber;
import io.circe.JsonObject;
import io.circe.yaml.PrinterBuilder$;
import io.circe.yaml.PrinterImpl$;
import io.circe.yaml.common.Printer;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.emitter.Emitable;
import org.yaml.snakeyaml.emitter.Emitter;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.resolver.Resolver;
import org.yaml.snakeyaml.serializer.Serializer;
import scala.Function1;
import scala.None$;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;

public class PrinterImpl
implements Printer {
    private final Printer.StringStyle stringStyle;
    private final boolean preserveOrder;
    private final boolean dropNullKeys;
    private final Printer.FlowStyle mappingStyle;
    private final Printer.FlowStyle sequenceStyle;
    private final DumperOptions options;

    public PrinterImpl(Printer.StringStyle stringStyle, boolean preserveOrder, boolean dropNullKeys, Printer.FlowStyle mappingStyle, Printer.FlowStyle sequenceStyle, DumperOptions options) {
        this.stringStyle = stringStyle;
        this.preserveOrder = preserveOrder;
        this.dropNullKeys = dropNullKeys;
        this.mappingStyle = mappingStyle;
        this.sequenceStyle = sequenceStyle;
        this.options = options;
    }

    public String pretty(Json json) {
        Tag rootTag = PrinterImpl$.MODULE$.io$circe$yaml$PrinterImpl$$$yamlTag(json);
        StringWriter writer = new StringWriter();
        Serializer serializer = new Serializer((Emitable)new Emitter((Writer)writer, this.options), new Resolver(), this.options, rootTag);
        serializer.open();
        serializer.serialize(this.jsonToYaml(json));
        serializer.close();
        return writer.toString();
    }

    private boolean isBad(String s) {
        return s.indexOf(133) >= 0 || s.indexOf(65279) >= 0;
    }

    private boolean hasNewline(String s) {
        return s.indexOf(10) >= 0;
    }

    private DumperOptions.ScalarStyle scalarStyle(String value) {
        if (this.isBad(value)) {
            return DumperOptions.ScalarStyle.DOUBLE_QUOTED;
        }
        return DumperOptions.ScalarStyle.PLAIN;
    }

    private DumperOptions.ScalarStyle stringScalarStyle(String value) {
        if (this.isBad(value)) {
            return DumperOptions.ScalarStyle.DOUBLE_QUOTED;
        }
        Printer.StringStyle stringStyle = this.stringStyle;
        Printer.StringStyle$.Plain$ plain$ = Printer.StringStyle$.Plain$.MODULE$;
        if (!(stringStyle != null ? !stringStyle.equals(plain$) : plain$ != null) && this.hasNewline(value)) {
            return DumperOptions.ScalarStyle.LITERAL;
        }
        return PrinterBuilder$.MODULE$.SnakeStringStyle(this.stringStyle).toScalarStyle();
    }

    private ScalarNode scalarNode(Tag tag, String value) {
        return new ScalarNode(tag, value, null, null, this.scalarStyle(value));
    }

    private ScalarNode stringNode(String value) {
        return new ScalarNode(Tag.STR, value, null, null, this.stringScalarStyle(value));
    }

    private ScalarNode keyNode(String value) {
        return new ScalarNode(Tag.STR, value, null, null, this.scalarStyle(value));
    }

    private Node jsonToYaml(Json json) {
        return (Node)json.fold(this::jsonToYaml$$anonfun$1, (Function1 & Serializable)bool -> this.jsonToYaml$$anonfun$2(BoxesRunTime.unboxToBoolean((Object)bool)), (Function1 & Serializable)number -> this.scalarNode(PrinterImpl$.MODULE$.io$circe$yaml$PrinterImpl$$$numberTag((JsonNumber)number), number.toString()), (Function1 & Serializable)str -> this.stringNode((String)str), (Function1 & Serializable)arr -> {
            Printer.FlowStyle flowStyle = this.sequenceStyle;
            Printer.FlowStyle$.Flow$ flow$ = Printer.FlowStyle$.Flow$.MODULE$;
            return new SequenceNode(Tag.SEQ, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)arr.map((Function1 & Serializable)json -> this.jsonToYaml((Json)json))).asJava(), !(flowStyle != null ? !flowStyle.equals(flow$) : flow$ != null) ? DumperOptions.FlowStyle.FLOW : DumperOptions.FlowStyle.BLOCK);
        }, (Function1 & Serializable)obj -> this.convertObject$1((JsonObject)obj));
    }

    private final MappingNode convertObject$1(JsonObject obj) {
        Iterable fields = this.preserveOrder ? obj.keys() : obj.keys().toSet();
        Map m = obj.toMap();
        Iterable childNodes = (Iterable)fields.flatMap((Function1 & Serializable)key -> {
            Json value = (Json)m.apply(key);
            if (!this.dropNullKeys || !value.isNull()) {
                return Some$.MODULE$.apply((Object)new NodeTuple((Node)this.keyNode((String)key), this.jsonToYaml(value)));
            }
            return None$.MODULE$;
        });
        Printer.FlowStyle flowStyle = this.mappingStyle;
        Printer.FlowStyle$.Flow$ flow$ = Printer.FlowStyle$.Flow$.MODULE$;
        return new MappingNode(Tag.MAP, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)childNodes.toList()).asJava(), !(flowStyle != null ? !flowStyle.equals(flow$) : flow$ != null) ? DumperOptions.FlowStyle.FLOW : DumperOptions.FlowStyle.BLOCK);
    }

    private final Node jsonToYaml$$anonfun$1() {
        return this.scalarNode(Tag.NULL, "null");
    }

    private final /* synthetic */ Node jsonToYaml$$anonfun$2(boolean bool) {
        return this.scalarNode(Tag.BOOL, BoxesRunTime.boxToBoolean((boolean)bool).toString());
    }
}

