/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.v1.avro.compact;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Map;
import org.apache.avro.AvroMissingFieldException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Conversion;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.data.TimeConversions;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class CloudEvent
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 6264489528723580858L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"CloudEvent\",\"namespace\":\"io.cloudevents.v1.avro.compact\",\"doc\":\"Avro Compact Event Format for CloudEvents\",\"fields\":[{\"name\":\"id\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"source\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"type\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},{\"name\":\"datacontenttype\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"dataschema\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"subject\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"time\",\"type\":[\"null\",{\"type\":\"long\",\"logicalType\":\"timestamp-micros\"}],\"default\":null},{\"name\":\"extensions\",\"type\":{\"type\":\"map\",\"values\":[\"boolean\",\"int\",{\"type\":\"long\",\"logicalType\":\"timestamp-micros\"},{\"type\":\"string\",\"avro.java.string\":\"String\"},\"bytes\"],\"avro.java.string\":\"String\"},\"default\":{}},{\"name\":\"data\",\"type\":[\"bytes\",\"null\"],\"default\":\"null\"}],\"version\":\"1.0\"}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<CloudEvent> ENCODER;
    private static final BinaryMessageDecoder<CloudEvent> DECODER;
    private String id;
    private String source;
    private String type;
    private String datacontenttype;
    private String dataschema;
    private String subject;
    private Instant time;
    private Map<String, Object> extensions;
    private ByteBuffer data;
    private static final DatumWriter<CloudEvent> WRITER$;
    private static final DatumReader<CloudEvent> READER$;

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<CloudEvent> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<CloudEvent> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<CloudEvent> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static CloudEvent fromByteBuffer(ByteBuffer b) throws IOException {
        return (CloudEvent)((Object)DECODER.decode(b));
    }

    public CloudEvent() {
    }

    public CloudEvent(String id, String source, String type, String datacontenttype, String dataschema, String subject, Instant time, Map<String, Object> extensions, ByteBuffer data) {
        this.id = id;
        this.source = source;
        this.type = type;
        this.datacontenttype = datacontenttype;
        this.dataschema = dataschema;
        this.subject = subject;
        this.time = time;
        this.extensions = extensions;
        this.data = data;
    }

    public SpecificData getSpecificData() {
        return MODEL$;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.id;
            }
            case 1: {
                return this.source;
            }
            case 2: {
                return this.type;
            }
            case 3: {
                return this.datacontenttype;
            }
            case 4: {
                return this.dataschema;
            }
            case 5: {
                return this.subject;
            }
            case 6: {
                return this.time;
            }
            case 7: {
                return this.extensions;
            }
            case 8: {
                return this.data;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.id = value$ != null ? value$.toString() : null;
                break;
            }
            case 1: {
                this.source = value$ != null ? value$.toString() : null;
                break;
            }
            case 2: {
                this.type = value$ != null ? value$.toString() : null;
                break;
            }
            case 3: {
                this.datacontenttype = value$ != null ? value$.toString() : null;
                break;
            }
            case 4: {
                this.dataschema = value$ != null ? value$.toString() : null;
                break;
            }
            case 5: {
                this.subject = value$ != null ? value$.toString() : null;
                break;
            }
            case 6: {
                this.time = (Instant)value$;
                break;
            }
            case 7: {
                this.extensions = (Map)value$;
                break;
            }
            case 8: {
                this.data = (ByteBuffer)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String value) {
        this.source = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        this.type = value;
    }

    public String getDatacontenttype() {
        return this.datacontenttype;
    }

    public void setDatacontenttype(String value) {
        this.datacontenttype = value;
    }

    public String getDataschema() {
        return this.dataschema;
    }

    public void setDataschema(String value) {
        this.dataschema = value;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String value) {
        this.subject = value;
    }

    public Instant getTime() {
        return this.time;
    }

    public void setTime(Instant value) {
        this.time = value;
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Map<String, Object> value) {
        this.extensions = value;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public void setData(ByteBuffer value) {
        this.data = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(CloudEvent other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    static {
        MODEL$.addLogicalTypeConversion((Conversion)new TimeConversions.TimestampMicrosConversion());
        ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
        DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
        WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
        READER$ = MODEL$.createDatumReader(SCHEMA$);
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<CloudEvent>
    implements RecordBuilder<CloudEvent> {
        private String id;
        private String source;
        private String type;
        private String datacontenttype;
        private String dataschema;
        private String subject;
        private Instant time;
        private Map<String, Object> extensions;
        private ByteBuffer data;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.id)) {
                this.id = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.id);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.source)) {
                this.source = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.source);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.type)) {
                this.type = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.type);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.datacontenttype)) {
                this.datacontenttype = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.datacontenttype);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.dataschema)) {
                this.dataschema = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.dataschema);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.subject)) {
                this.subject = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.subject);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.time)) {
                this.time = (Instant)this.data().deepCopy(this.fields()[6].schema(), (Object)other.time);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], other.extensions)) {
                this.extensions = (Map)this.data().deepCopy(this.fields()[7].schema(), other.extensions);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.data)) {
                this.data = (ByteBuffer)this.data().deepCopy(this.fields()[8].schema(), (Object)other.data);
                this.fieldSetFlags()[8] = other.fieldSetFlags()[8];
            }
        }

        private Builder(CloudEvent other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.id)) {
                this.id = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.id);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.source)) {
                this.source = (String)this.data().deepCopy(this.fields()[1].schema(), (Object)other.source);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.type)) {
                this.type = (String)this.data().deepCopy(this.fields()[2].schema(), (Object)other.type);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.datacontenttype)) {
                this.datacontenttype = (String)this.data().deepCopy(this.fields()[3].schema(), (Object)other.datacontenttype);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.dataschema)) {
                this.dataschema = (String)this.data().deepCopy(this.fields()[4].schema(), (Object)other.dataschema);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.subject)) {
                this.subject = (String)this.data().deepCopy(this.fields()[5].schema(), (Object)other.subject);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.time)) {
                this.time = (Instant)this.data().deepCopy(this.fields()[6].schema(), (Object)other.time);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.extensions)) {
                this.extensions = (Map)this.data().deepCopy(this.fields()[7].schema(), (Object)other.extensions);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)other.data)) {
                this.data = (ByteBuffer)this.data().deepCopy(this.fields()[8].schema(), (Object)other.data);
                this.fieldSetFlags()[8] = true;
            }
        }

        public String getId() {
            return this.id;
        }

        public Builder setId(String value) {
            this.validate(this.fields()[0], value);
            this.id = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasId() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearId() {
            this.id = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public String getSource() {
            return this.source;
        }

        public Builder setSource(String value) {
            this.validate(this.fields()[1], value);
            this.source = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasSource() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearSource() {
            this.source = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public String getType() {
            return this.type;
        }

        public Builder setType(String value) {
            this.validate(this.fields()[2], value);
            this.type = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasType() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearType() {
            this.type = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public String getDatacontenttype() {
            return this.datacontenttype;
        }

        public Builder setDatacontenttype(String value) {
            this.validate(this.fields()[3], value);
            this.datacontenttype = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasDatacontenttype() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearDatacontenttype() {
            this.datacontenttype = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public String getDataschema() {
            return this.dataschema;
        }

        public Builder setDataschema(String value) {
            this.validate(this.fields()[4], value);
            this.dataschema = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasDataschema() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearDataschema() {
            this.dataschema = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public String getSubject() {
            return this.subject;
        }

        public Builder setSubject(String value) {
            this.validate(this.fields()[5], value);
            this.subject = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasSubject() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearSubject() {
            this.subject = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Instant getTime() {
            return this.time;
        }

        public Builder setTime(Instant value) {
            this.validate(this.fields()[6], value);
            this.time = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasTime() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearTime() {
            this.time = null;
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Map<String, Object> getExtensions() {
            return this.extensions;
        }

        public Builder setExtensions(Map<String, Object> value) {
            this.validate(this.fields()[7], value);
            this.extensions = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasExtensions() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearExtensions() {
            this.extensions = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public ByteBuffer getData() {
            return this.data;
        }

        public Builder setData(ByteBuffer value) {
            this.validate(this.fields()[8], value);
            this.data = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasData() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearData() {
            this.data = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public CloudEvent build() {
            try {
                CloudEvent record = new CloudEvent();
                record.id = this.fieldSetFlags()[0] ? this.id : (String)this.defaultValue(this.fields()[0]);
                record.source = this.fieldSetFlags()[1] ? this.source : (String)this.defaultValue(this.fields()[1]);
                record.type = this.fieldSetFlags()[2] ? this.type : (String)this.defaultValue(this.fields()[2]);
                record.datacontenttype = this.fieldSetFlags()[3] ? this.datacontenttype : (String)this.defaultValue(this.fields()[3]);
                record.dataschema = this.fieldSetFlags()[4] ? this.dataschema : (String)this.defaultValue(this.fields()[4]);
                record.subject = this.fieldSetFlags()[5] ? this.subject : (String)this.defaultValue(this.fields()[5]);
                record.time = this.fieldSetFlags()[6] ? this.time : (Instant)this.defaultValue(this.fields()[6]);
                record.extensions = this.fieldSetFlags()[7] ? this.extensions : (Map)this.defaultValue(this.fields()[7]);
                record.data = this.fieldSetFlags()[8] ? this.data : (ByteBuffer)this.defaultValue(this.fields()[8]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

