/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.builder;

import io.cloudevents.CloudEvent;
import io.cloudevents.Extension;
import io.cloudevents.SpecVersion;
import io.cloudevents.rw.CloudEventWriter;
import java.net.URI;
import java.time.ZonedDateTime;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

@ParametersAreNullableByDefault
public interface CloudEventBuilder
extends CloudEventWriter<CloudEvent> {
    public CloudEventBuilder withId(String var1);

    public CloudEventBuilder withSource(URI var1);

    public CloudEventBuilder withType(String var1);

    public CloudEventBuilder withDataSchema(URI var1);

    public CloudEventBuilder withDataContentType(String var1);

    public CloudEventBuilder withSubject(String var1);

    public CloudEventBuilder withTime(ZonedDateTime var1);

    public CloudEventBuilder withData(byte[] var1);

    public CloudEventBuilder withData(String var1, byte[] var2);

    public CloudEventBuilder withData(String var1, URI var2, byte[] var3);

    public CloudEventBuilder withExtension(@Nonnull String var1, String var2);

    public CloudEventBuilder withExtension(@Nonnull String var1, Number var2);

    public CloudEventBuilder withExtension(@Nonnull String var1, boolean var2);

    public CloudEventBuilder withExtension(@Nonnull Extension var1);

    public CloudEvent build() throws IllegalStateException;

    public CloudEventBuilder newBuilder();

    public static io.cloudevents.core.v1.CloudEventBuilder v1() {
        return new io.cloudevents.core.v1.CloudEventBuilder();
    }

    public static io.cloudevents.core.v1.CloudEventBuilder v1(@Nonnull CloudEvent event) {
        return new io.cloudevents.core.v1.CloudEventBuilder(event);
    }

    public static io.cloudevents.core.v03.CloudEventBuilder v03() {
        return new io.cloudevents.core.v03.CloudEventBuilder();
    }

    public static io.cloudevents.core.v03.CloudEventBuilder v03(@Nonnull CloudEvent event) {
        return new io.cloudevents.core.v03.CloudEventBuilder(event);
    }

    public static CloudEventBuilder fromSpecVersion(@Nonnull SpecVersion version) {
        switch (version) {
            case V1: {
                return CloudEventBuilder.v1();
            }
            case V03: {
                return CloudEventBuilder.v03();
            }
        }
        throw new IllegalStateException("The provided spec version doesn't exist. Please make sure your io.cloudevents deps versions are aligned.");
    }
}

