/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.v03;

import io.cloudevents.SpecVersion;
import io.cloudevents.core.impl.BaseCloudEvent;
import io.cloudevents.core.v03.ContextAttributes;
import io.cloudevents.lang.Nullable;
import io.cloudevents.rw.CloudEventAttributesWriter;
import io.cloudevents.rw.CloudEventRWException;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public final class CloudEventV03
extends BaseCloudEvent {
    private final String id;
    private final URI source;
    private final String type;
    private final String datacontenttype;
    private final URI schemaurl;
    private final String subject;
    private final ZonedDateTime time;

    public CloudEventV03(String id, URI source, String type, ZonedDateTime time, URI schemaurl, String datacontenttype, String subject, byte[] data, Map<String, Object> extensions) {
        super(data, extensions);
        this.id = id;
        this.source = source;
        this.type = type;
        this.time = time;
        this.schemaurl = schemaurl;
        this.datacontenttype = datacontenttype;
        this.subject = subject;
    }

    public SpecVersion getSpecVersion() {
        return SpecVersion.V03;
    }

    public String getId() {
        return this.id;
    }

    public URI getSource() {
        return this.source;
    }

    public String getType() {
        return this.type;
    }

    public String getDataContentType() {
        return this.datacontenttype;
    }

    public URI getDataSchema() {
        return this.schemaurl;
    }

    @Nullable
    public URI getSchemaUrl() {
        return this.schemaurl;
    }

    public String getSubject() {
        return this.subject;
    }

    public ZonedDateTime getTime() {
        return this.time;
    }

    public Object getAttribute(String attributeName) {
        switch (attributeName) {
            case "specversion": {
                return this.getSpecVersion();
            }
            case "id": {
                return this.id;
            }
            case "source": {
                return this.source;
            }
            case "type": {
                return this.type;
            }
            case "datacontenttype": {
                return this.datacontenttype;
            }
            case "schemaurl": {
                return this.schemaurl;
            }
            case "subject": {
                return this.subject;
            }
            case "time": {
                return this.time;
            }
        }
        throw new IllegalArgumentException("Spec version v0.3 doesn't have attribute named " + attributeName);
    }

    public void readAttributes(CloudEventAttributesWriter writer) throws CloudEventRWException {
        writer.setAttribute(ContextAttributes.ID.name().toLowerCase(), this.id);
        writer.setAttribute(ContextAttributes.SOURCE.name().toLowerCase(), this.source);
        writer.setAttribute(ContextAttributes.TYPE.name().toLowerCase(), this.type);
        if (this.datacontenttype != null) {
            writer.setAttribute(ContextAttributes.DATACONTENTTYPE.name().toLowerCase(), this.datacontenttype);
        }
        if (this.schemaurl != null) {
            writer.setAttribute(ContextAttributes.SCHEMAURL.name().toLowerCase(), this.schemaurl);
        }
        if (this.subject != null) {
            writer.setAttribute(ContextAttributes.SUBJECT.name().toLowerCase(), this.subject);
        }
        if (this.time != null) {
            writer.setAttribute(ContextAttributes.TIME.name().toLowerCase(), this.time);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudEventV03 that = (CloudEventV03)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getSource(), that.getSource()) && Objects.equals(this.getType(), that.getType()) && Objects.equals(this.datacontenttype, that.datacontenttype) && Objects.equals(this.schemaurl, that.schemaurl) && Objects.equals(this.getSubject(), that.getSubject()) && Objects.equals(this.getTime(), that.getTime()) && Arrays.equals(this.getData(), that.getData()) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getSource(), this.getType(), this.datacontenttype, this.schemaurl, this.getSubject(), this.getTime(), Arrays.hashCode(this.getData()), this.extensions);
    }

    public String toString() {
        return "CloudEvent{id='" + this.id + '\'' + ", source=" + this.source + ", type='" + this.type + '\'' + ", datacontenttype='" + this.datacontenttype + '\'' + ", schemaurl=" + this.schemaurl + ", subject='" + this.subject + '\'' + ", time=" + this.time + ", data=" + Arrays.toString(this.getData()) + ", extensions" + this.extensions + '}';
    }
}

