/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.core.v1;

import io.cloudevents.CloudEventData;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.impl.BaseCloudEvent;
import io.cloudevents.rw.CloudEventContextWriter;
import io.cloudevents.rw.CloudEventRWException;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Objects;

public final class CloudEventV1
extends BaseCloudEvent {
    public static final String ID = "id";
    public static final String SOURCE = "source";
    public static final String SPECVERSION = "specversion";
    public static final String TYPE = "type";
    public static final String TIME = "time";
    public static final String DATASCHEMA = "dataschema";
    public static final String DATACONTENTTYPE = "datacontenttype";
    public static final String SUBJECT = "subject";
    private final String id;
    private final URI source;
    private final String type;
    private final String datacontenttype;
    private final URI dataschema;
    private final String subject;
    private final OffsetDateTime time;

    public CloudEventV1(String id, URI source, String type, String datacontenttype, URI dataschema, String subject, OffsetDateTime time, CloudEventData data, Map<String, Object> extensions) {
        super(data, extensions);
        this.id = id;
        this.source = source;
        this.type = type;
        this.datacontenttype = datacontenttype;
        this.dataschema = dataschema;
        this.subject = subject;
        this.time = time;
    }

    public SpecVersion getSpecVersion() {
        return SpecVersion.V1;
    }

    public String getId() {
        return this.id;
    }

    public URI getSource() {
        return this.source;
    }

    public String getType() {
        return this.type;
    }

    public String getDataContentType() {
        return this.datacontenttype;
    }

    public URI getDataSchema() {
        return this.dataschema;
    }

    public String getSubject() {
        return this.subject;
    }

    public OffsetDateTime getTime() {
        return this.time;
    }

    public Object getAttribute(String attributeName) {
        switch (attributeName) {
            case "specversion": {
                return this.getSpecVersion();
            }
            case "id": {
                return this.id;
            }
            case "source": {
                return this.source;
            }
            case "type": {
                return this.type;
            }
            case "datacontenttype": {
                return this.datacontenttype;
            }
            case "dataschema": {
                return this.dataschema;
            }
            case "subject": {
                return this.subject;
            }
            case "time": {
                return this.time;
            }
        }
        throw new IllegalArgumentException("Spec version v1 doesn't have attribute named " + attributeName);
    }

    public void readContext(CloudEventContextWriter writer) throws CloudEventRWException {
        writer.withContextAttribute(ID, this.id);
        writer.withContextAttribute(SOURCE, this.source);
        writer.withContextAttribute(TYPE, this.type);
        if (this.datacontenttype != null) {
            writer.withContextAttribute(DATACONTENTTYPE, this.datacontenttype);
        }
        if (this.dataschema != null) {
            writer.withContextAttribute(DATASCHEMA, this.dataschema);
        }
        if (this.subject != null) {
            writer.withContextAttribute(SUBJECT, this.subject);
        }
        if (this.time != null) {
            writer.withContextAttribute(TIME, this.time);
        }
        this.readExtensions(writer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudEventV1 that = (CloudEventV1)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getSource(), that.getSource()) && Objects.equals(this.getType(), that.getType()) && Objects.equals(this.datacontenttype, that.getDataContentType()) && Objects.equals(this.dataschema, that.getDataSchema()) && Objects.equals(this.getSubject(), that.getSubject()) && Objects.equals(this.getTime(), that.getTime()) && Objects.equals(this.getData(), that.getData()) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getSource(), this.getType(), this.datacontenttype, this.dataschema, this.getSubject(), this.getTime(), this.getData(), this.extensions);
    }

    public String toString() {
        return "CloudEvent{id='" + this.id + '\'' + ", source=" + this.source + ", type='" + this.type + '\'' + ", datacontenttype='" + this.datacontenttype + '\'' + ", dataschema=" + this.dataschema + ", subject='" + this.subject + '\'' + ", time=" + this.time + ", data=" + this.getData() + ", extensions=" + this.extensions + '}';
    }
}

