/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.http.vertx.impl;

import io.cloudevents.SpecVersion;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.message.MessageWriter;
import io.cloudevents.http.vertx.impl.CloudEventsHeaders;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventWriter;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;

public class VertxHttpServerResponseMessageWriterImpl
implements MessageWriter<CloudEventWriter<HttpServerResponse>, HttpServerResponse>,
CloudEventWriter<HttpServerResponse> {
    private final HttpServerResponse response;

    public VertxHttpServerResponseMessageWriterImpl(HttpServerResponse response) {
        this.response = response;
    }

    public CloudEventWriter<HttpServerResponse> create(SpecVersion version) {
        this.response.putHeader(CloudEventsHeaders.SPEC_VERSION, (CharSequence)version.toString());
        return this;
    }

    public void setAttribute(String name, String value) throws CloudEventRWException {
        this.response.putHeader(CloudEventsHeaders.ATTRIBUTES_TO_HEADERS.get(name), (CharSequence)value);
    }

    public void setExtension(String name, String value) throws CloudEventRWException {
        this.response.putHeader("ce-" + name, value);
    }

    public HttpServerResponse end(byte[] value) throws CloudEventRWException {
        if (this.response.ended()) {
            throw CloudEventRWException.newOther((Throwable)new IllegalStateException("Cannot set the body because the response is already ended"));
        }
        this.response.end(Buffer.buffer((byte[])value));
        return this.response;
    }

    public HttpServerResponse end() {
        if (!this.response.ended()) {
            this.response.end();
        }
        return this.response;
    }

    public HttpServerResponse setEvent(EventFormat format, byte[] value) throws CloudEventRWException {
        this.response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)format.serializedContentType());
        this.response.end(Buffer.buffer((byte[])value));
        return this.response;
    }
}

