/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.kafka;

import io.cloudevents.Attributes;
import io.cloudevents.CloudEvent;
import io.cloudevents.format.builder.HeadersStep;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudEventsKafkaConsumer<K, A extends Attributes, T>
implements Consumer<K, CloudEvent<A, T>> {
    private static final Logger log = LoggerFactory.getLogger(CloudEventsKafkaConsumer.class);
    private static final String CE_CONTENT_TYPE = "application/cloudevents+";
    private static final String CONTENT_TYPE_HEADER = "content-type";
    private final Consumer<K, byte[]> consumer;
    private HeadersStep<A, T, byte[]> builder;

    public CloudEventsKafkaConsumer(Properties configuration, HeadersStep<A, T, byte[]> builder) {
        Objects.requireNonNull(configuration);
        Objects.requireNonNull(builder);
        Optional.ofNullable(configuration.get("value.deserializer")).map(config -> config.toString()).filter(config -> !config.contains(ByteArrayDeserializer.class.getName())).ifPresent(wrong -> {
            log.warn("Fixing the wrong deserializer {}", wrong);
            configuration.put("value.deserializer", ByteArrayDeserializer.class);
        });
        this.builder = builder;
        this.consumer = new KafkaConsumer(configuration);
    }

    public CloudEventsKafkaConsumer(HeadersStep<A, T, byte[]> builder, Consumer<K, byte[]> consumer) {
        Objects.requireNonNull(builder);
        Objects.requireNonNull(consumer);
        this.builder = builder;
        this.consumer = consumer;
    }

    private static Map<String, Object> asMap(Headers kafkaHeaders) {
        return StreamSupport.stream(kafkaHeaders.spliterator(), Boolean.FALSE).map(header -> new AbstractMap.SimpleEntry<String, byte[]>(header.key(), header.value())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private ConsumerRecords<K, CloudEvent<A, T>> build(ConsumerRecords<K, byte[]> records) {
        ArrayList newRecords = new ArrayList();
        records.forEach(record -> {
            CloudEvent value = this.builder.withHeaders(() -> CloudEventsKafkaConsumer.asMap(record.headers())).withPayload(() -> (byte[])record.value()).unmarshal();
            newRecords.add(new ConsumerRecord(record.topic(), record.partition(), record.offset(), record.timestamp(), record.timestampType(), Long.valueOf(record.checksum()), record.serializedKeySize(), record.serializedValueSize(), record.key(), (Object)value, record.headers()));
        });
        Map<TopicPartition, List<ConsumerRecord>> result = newRecords.stream().collect(Collectors.groupingBy(record -> new TopicPartition(record.topic(), record.partition())));
        return new ConsumerRecords(result);
    }

    @Deprecated
    public ConsumerRecords<K, CloudEvent<A, T>> poll(long timeout) {
        return this.build(this.consumer.poll(timeout));
    }

    public ConsumerRecords<K, CloudEvent<A, T>> poll(Duration duration) {
        return this.build(this.consumer.poll(duration));
    }

    public void assign(Collection<TopicPartition> arg0) {
        this.consumer.assign(arg0);
    }

    public Set<TopicPartition> assignment() {
        return this.consumer.assignment();
    }

    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> arg0) {
        return this.consumer.beginningOffsets(arg0);
    }

    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> arg0, Duration arg1) {
        return this.consumer.beginningOffsets(arg0, arg1);
    }

    public void close() {
        this.consumer.close();
    }

    public void close(Duration arg0) {
        this.consumer.close(arg0);
    }

    @Deprecated
    public void close(long arg0, TimeUnit arg1) {
        this.consumer.close(arg0, arg1);
    }

    public void commitAsync() {
        this.consumer.commitAsync();
    }

    public void commitAsync(OffsetCommitCallback arg0) {
        this.consumer.commitAsync(arg0);
    }

    public void commitAsync(Map<TopicPartition, OffsetAndMetadata> arg0, OffsetCommitCallback arg1) {
        this.consumer.commitAsync(arg0, arg1);
    }

    public void commitSync() {
        this.consumer.commitSync();
    }

    public void commitSync(Duration arg0) {
        this.consumer.commitSync();
    }

    public void commitSync(Map<TopicPartition, OffsetAndMetadata> arg0) {
        this.consumer.commitSync(arg0);
    }

    public void commitSync(Map<TopicPartition, OffsetAndMetadata> arg0, Duration arg1) {
        this.consumer.commitSync(arg0, arg1);
    }

    public OffsetAndMetadata committed(TopicPartition arg0) {
        return this.consumer.committed(arg0);
    }

    public OffsetAndMetadata committed(TopicPartition arg0, Duration arg1) {
        return this.consumer.committed(arg0, arg1);
    }

    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> arg0) {
        return this.consumer.endOffsets(arg0);
    }

    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> arg0, Duration arg1) {
        return this.consumer.endOffsets(arg0, arg1);
    }

    public Map<String, List<PartitionInfo>> listTopics() {
        return this.consumer.listTopics();
    }

    public Map<String, List<PartitionInfo>> listTopics(Duration arg0) {
        return this.consumer.listTopics(arg0);
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return this.consumer.metrics();
    }

    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> arg0) {
        return this.consumer.offsetsForTimes(arg0);
    }

    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> arg0, Duration arg1) {
        return this.consumer.offsetsForTimes(arg0, arg1);
    }

    public List<PartitionInfo> partitionsFor(String arg0) {
        return this.consumer.partitionsFor(arg0);
    }

    public List<PartitionInfo> partitionsFor(String arg0, Duration arg1) {
        return this.consumer.partitionsFor(arg0, arg1);
    }

    public void pause(Collection<TopicPartition> arg0) {
        this.consumer.pause(arg0);
    }

    public Set<TopicPartition> paused() {
        return this.consumer.paused();
    }

    public long position(TopicPartition arg0) {
        return this.consumer.position(arg0);
    }

    public long position(TopicPartition arg0, Duration arg1) {
        return this.consumer.position(arg0, arg1);
    }

    public void resume(Collection<TopicPartition> arg0) {
        this.consumer.resume(arg0);
    }

    public void seek(TopicPartition arg0, long arg1) {
        this.consumer.seek(arg0, arg1);
    }

    public void seekToBeginning(Collection<TopicPartition> arg0) {
        this.consumer.seekToBeginning(arg0);
    }

    public void seekToEnd(Collection<TopicPartition> arg0) {
        this.consumer.seekToEnd(arg0);
    }

    public void subscribe(Collection<String> arg0) {
        this.consumer.subscribe(arg0);
    }

    public void subscribe(Pattern arg0) {
        this.consumer.subscribe(arg0);
    }

    public void subscribe(Collection<String> arg0, ConsumerRebalanceListener arg1) {
        this.consumer.subscribe(arg0, arg1);
    }

    public void subscribe(Pattern arg0, ConsumerRebalanceListener arg1) {
        this.consumer.subscribe(arg0, arg1);
    }

    public Set<String> subscription() {
        return this.consumer.subscription();
    }

    public void unsubscribe() {
        this.consumer.unsubscribe();
    }

    public void wakeup() {
        this.consumer.wakeup();
    }
}

