/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.v1.kafka;

import io.cloudevents.v1.ContextAttributes;
import java.util.AbstractMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;

public class HeaderMapper {
    private static final Serializer<String> SERIALIZER = Serdes.String().serializer();
    private static final String KAFKA_CONTENT_TYPE = "content-type";

    private HeaderMapper() {
    }

    public static Map<String, byte[]> map(Map<String, String> attributes, Map<String, String> extensions) {
        Objects.requireNonNull(attributes);
        Objects.requireNonNull(extensions);
        Map<String, byte[]> result = attributes.entrySet().stream().filter(attribute -> null != attribute.getValue()).map(attribute -> new AbstractMap.SimpleEntry(((String)attribute.getKey()).toLowerCase(Locale.US), attribute.getValue())).filter(header -> !((String)header.getKey()).equals(ContextAttributes.datacontenttype.name())).map(attribute -> new AbstractMap.SimpleEntry("ce_" + (String)attribute.getKey(), attribute.getValue())).map(attribute -> new AbstractMap.SimpleEntry(attribute.getKey(), SERIALIZER.serialize(null, attribute.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        result.putAll(extensions.entrySet().stream().filter(extension -> null != extension.getValue()).map(extension -> new AbstractMap.SimpleEntry(extension.getKey(), SERIALIZER.serialize(null, extension.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        Optional.ofNullable(attributes.get(ContextAttributes.datacontenttype.name())).ifPresent(dct -> result.put(KAFKA_CONTENT_TYPE, SERIALIZER.serialize(null, dct)));
        return result;
    }
}

