/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.v03.kafka;

import io.cloudevents.CloudEvent;
import io.cloudevents.extensions.DistributedTracingExtension;
import io.cloudevents.extensions.ExtensionFormat;
import io.cloudevents.format.BinaryUnmarshaller;
import io.cloudevents.format.StructuredUnmarshaller;
import io.cloudevents.format.builder.HeadersStep;
import io.cloudevents.json.Json;
import io.cloudevents.v03.AttributesImpl;
import io.cloudevents.v03.CloudEventBuilder;
import io.cloudevents.v03.CloudEventImpl;
import io.cloudevents.v03.kafka.AttributeMapper;
import io.cloudevents.v03.kafka.ExtensionMapper;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class Unmarshallers {
    private Unmarshallers() {
    }

    public static <T> HeadersStep<AttributesImpl, T, byte[]> binary(Class<T> type) {
        return BinaryUnmarshaller.builder().map(AttributeMapper::map).map(AttributesImpl::unmarshal).map("application/json", Json.binaryUmarshaller(type)).next().map(ExtensionMapper::map).map(DistributedTracingExtension::unmarshall).next().builder((arg_0, arg_1, arg_2) -> ((CloudEventBuilder)CloudEventBuilder.builder()).build(arg_0, arg_1, arg_2));
    }

    public static <T> HeadersStep<AttributesImpl, T, byte[]> structured(Class<T> typeOfData) {
        return StructuredUnmarshaller.builder().map(ExtensionMapper::map).map(DistributedTracingExtension::unmarshall).next().map((payload, extensions) -> {
            CloudEventImpl event = (CloudEventImpl)Json.binaryDecodeValue((byte[])payload, CloudEventImpl.class, (Class[])new Class[]{typeOfData});
            Optional<ExtensionFormat> dteFormat = Optional.ofNullable(event.getExtensions().get("distributedTracing")).filter(extension -> extension instanceof Map).map(extension -> (Map)extension).map(extension -> extension.entrySet().stream().filter(entry -> null != entry.getKey() && null != entry.getValue()).map(tracing -> new AbstractMap.SimpleEntry(tracing.getKey(), tracing.getValue().toString())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).map(extension -> {
                DistributedTracingExtension dte = new DistributedTracingExtension();
                dte.setTraceparent((String)extension.get("traceparent"));
                dte.setTracestate((String)extension.get("tracestate"));
                return new DistributedTracingExtension.Format(dte);
            });
            CloudEventBuilder builder = CloudEventBuilder.builder((CloudEvent)event);
            ((List)extensions.get()).forEach(extension -> builder.withExtension(extension));
            dteFormat.ifPresent(tracing -> builder.withExtension(tracing));
            return builder.build();
        });
    }
}

