/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.kafka.impl;

import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.message.MessageWriter;
import io.cloudevents.kafka.impl.KafkaHeaders;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventWriter;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;

abstract class BaseKafkaMessageWriterImpl<R>
implements MessageWriter<CloudEventWriter<R>, R>,
CloudEventWriter<R> {
    byte[] value;
    final Headers headers;

    public BaseKafkaMessageWriterImpl(Headers headers) {
        this.headers = headers;
    }

    public BaseKafkaMessageWriterImpl<R> withAttribute(String name, String value) throws CloudEventRWException {
        this.headers.add((Header)new RecordHeader(KafkaHeaders.ATTRIBUTES_TO_HEADERS.get(name), value.getBytes()));
        return this;
    }

    public BaseKafkaMessageWriterImpl<R> withExtension(String name, String value) throws CloudEventRWException {
        this.headers.add((Header)new RecordHeader("ce_" + name, value.getBytes()));
        return this;
    }

    public R end(byte[] value) throws CloudEventRWException {
        this.value = value;
        return (R)this.end();
    }

    public R setEvent(EventFormat format, byte[] value) throws CloudEventRWException {
        this.headers.add((Header)new RecordHeader("content-type", format.serializedContentType().getBytes()));
        return this.end(value);
    }
}

