/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.kafka;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.message.MessageReader;
import io.cloudevents.kafka.KafkaMessageFactory;
import io.cloudevents.rw.CloudEventDataMapper;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;

public class CloudEventDeserializer
implements Deserializer<CloudEvent> {
    public static final String MAPPER_CONFIG = "cloudevents.datamapper";
    private CloudEventDataMapper mapper = null;

    public void configure(Map<String, ?> configs, boolean isKey) {
        Object mapperConfig = configs.get(MAPPER_CONFIG);
        if (mapperConfig instanceof CloudEventDataMapper) {
            this.mapper = (CloudEventDataMapper)mapperConfig;
        } else if (mapperConfig != null) {
            throw new IllegalArgumentException("cloudevents.datamapper can be of type String or " + CloudEventDataMapper.class.getCanonicalName());
        }
    }

    public CloudEvent deserialize(String topic, byte[] data) {
        throw new UnsupportedOperationException("CloudEventDeserializer supports only the signature deserialize(String, Headers, byte[])");
    }

    public CloudEvent deserialize(String topic, Headers headers, byte[] data) {
        MessageReader reader = KafkaMessageFactory.createReader(headers, data);
        if (this.mapper == null) {
            return reader.toEvent();
        }
        return reader.toEvent(this.mapper);
    }
}

