/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.protobuf;

import com.google.protobuf.Any;
import com.google.protobuf.Message;
import io.cloudevents.protobuf.ProtoCloudEventData;
import io.cloudevents.protobuf.ProtoSupport;
import java.util.Objects;

class ProtoDataWrapper
implements ProtoCloudEventData {
    private final Any protoAny;

    ProtoDataWrapper(Message protoMessage) {
        Objects.requireNonNull(protoMessage);
        this.protoAny = protoMessage instanceof Any ? (Any)protoMessage : Any.pack((Message)protoMessage);
    }

    @Override
    public Any getAny() {
        return this.protoAny;
    }

    public byte[] toBytes() {
        return this.protoAny.toByteArray();
    }

    public boolean equals(Object obj) {
        Any rhsAny;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProtoDataWrapper)) {
            return false;
        }
        ProtoDataWrapper rhs = (ProtoDataWrapper)obj;
        Any lhsAny = this.getAny();
        if (lhsAny == (rhsAny = rhs.getAny())) {
            return true;
        }
        boolean typesMatch = ProtoSupport.extractMessageType(lhsAny).equals(ProtoSupport.extractMessageType(rhsAny));
        if (typesMatch) {
            return lhsAny.getValue().equals((Object)rhsAny.getValue());
        }
        return false;
    }
}

