/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.spring.mvc;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.CloudEventUtils;
import io.cloudevents.rw.CloudEventWriterFactory;
import io.cloudevents.spring.http.CloudEventHttpUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.StreamUtils;

public class CloudEventHttpMessageConverter
extends AbstractHttpMessageConverter<CloudEvent> {
    public CloudEventHttpMessageConverter() {
        super(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM, MediaType.ALL});
    }

    protected boolean supports(Class<?> clazz) {
        return CloudEvent.class.isAssignableFrom(clazz);
    }

    protected CloudEvent readInternal(Class<? extends CloudEvent> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        byte[] body = StreamUtils.copyToByteArray((InputStream)inputMessage.getBody());
        return CloudEventHttpUtils.toReader(inputMessage.getHeaders(), () -> body).toEvent();
    }

    protected void writeInternal(CloudEvent event, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        CloudEventUtils.toReader((CloudEvent)event).read((CloudEventWriterFactory)CloudEventHttpUtils.toWriter(outputMessage.getHeaders(), body -> this.copy((byte[])body, outputMessage)));
    }

    private void copy(byte[] body, HttpOutputMessage outputMessage) {
        try {
            StreamUtils.copy((byte[])body, (OutputStream)outputMessage.getBody());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

