/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.spring.codec;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.provider.EventFormatProvider;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractDataBufferDecoder;
import org.springframework.core.codec.DecodingException;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;

public class CloudEventDecoder
extends AbstractDataBufferDecoder<CloudEvent> {
    public CloudEventDecoder() {
        super(EventFormatProvider.getInstance().getContentTypes().stream().map(type -> MimeTypeUtils.parseMimeType((String)type)).collect(Collectors.toList()).toArray(new MimeType[0]));
    }

    public boolean canDecode(ResolvableType elementType, @Nullable MimeType mimeType) {
        Class clazz = elementType.toClass();
        return super.canDecode(elementType, mimeType) && CloudEvent.class.isAssignableFrom(clazz) && EventFormatProvider.getInstance().resolveFormat(mimeType.toString()) != null;
    }

    public CloudEvent decode(DataBuffer buffer, ResolvableType targetType, MimeType mimeType, Map<String, Object> hints) throws DecodingException {
        if (this.logger.isDebugEnabled() && !Hints.isLoggingSuppressed(hints)) {
            String logPrefix = Hints.getLogPrefix(hints);
            this.logger.debug((Object)(logPrefix + "Reading CloudEvent"));
        }
        EventFormat format = EventFormatProvider.getInstance().resolveFormat(mimeType.toString());
        byte[] result = new byte[buffer.readableByteCount()];
        buffer.read(result);
        DataBufferUtils.release((DataBuffer)buffer);
        return format.deserialize(result);
    }
}

