/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.sql.impl.expressions;

import io.cloudevents.CloudEvent;
import io.cloudevents.sql.EvaluationException;
import io.cloudevents.sql.EvaluationRuntime;
import io.cloudevents.sql.ExceptionFactory;
import io.cloudevents.sql.Function;
import io.cloudevents.sql.impl.ExpressionInternal;
import io.cloudevents.sql.impl.ExpressionInternalVisitor;
import io.cloudevents.sql.impl.expressions.BaseExpression;
import io.cloudevents.sql.impl.runtime.EvaluationContextImpl;
import io.cloudevents.sql.impl.runtime.EvaluationResult;
import io.cloudevents.sql.impl.runtime.TypeCastingProvider;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.misc.Interval;

public class FunctionInvocationExpression
extends BaseExpression {
    private final String functionName;
    private final List<ExpressionInternal> arguments;

    public FunctionInvocationExpression(Interval expressionInterval, String expressionText, String functionName, List<ExpressionInternal> arguments) {
        super(expressionInterval, expressionText);
        this.functionName = functionName.toUpperCase();
        this.arguments = arguments;
    }

    @Override
    public EvaluationResult evaluate(EvaluationRuntime runtime, CloudEvent event, ExceptionFactory exceptionFactory) {
        Function function;
        EvaluationContextImpl context = new EvaluationContextImpl(this.expressionInterval(), this.expressionText(), exceptionFactory);
        try {
            function = runtime.resolveFunction(this.functionName, this.arguments.size());
        }
        catch (Exception e) {
            return new EvaluationResult((Object)false, exceptionFactory.cannotDispatchFunction(this.expressionInterval(), this.expressionText(), this.functionName, e));
        }
        ArrayList<Object> computedArguments = new ArrayList<Object>(this.arguments.size());
        ArrayList<EvaluationException> exceptions = new ArrayList<EvaluationException>();
        for (int i = 0; i < this.arguments.size(); ++i) {
            ExpressionInternal expr = this.arguments.get(i);
            EvaluationResult computed = expr.evaluate(runtime, event, exceptionFactory);
            EvaluationResult casted = TypeCastingProvider.cast(context, computed, function.typeOfParameter(i));
            if (casted.causes() != null) {
                exceptions.addAll(casted.causes());
            }
            computedArguments.add(casted.value());
        }
        return function.invoke(context, runtime, event, computedArguments).wrapExceptions(exceptions);
    }

    @Override
    public <T> T visit(ExpressionInternalVisitor<T> visitor) {
        return visitor.visitFunctionInvocationExpression(this);
    }
}

