/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.sql.impl.runtime;

import io.cloudevents.sql.EvaluationException;
import io.cloudevents.sql.Result;
import io.cloudevents.sql.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EvaluationResult
implements Result {
    private final Object value;
    private final List<EvaluationException> exceptions;
    private final EvaluationException latestException;

    public EvaluationResult(Object value, List<EvaluationException> exceptions) {
        this.value = value;
        this.exceptions = exceptions == null ? new ArrayList() : exceptions;
        this.latestException = null;
    }

    public EvaluationResult(Object value, EvaluationException exception, EvaluationResult left, EvaluationResult right) {
        this.exceptions = Stream.concat(Stream.of(left, right).filter(Objects::nonNull).map(r -> r.exceptions).flatMap(Collection::stream), Stream.of(exception)).filter(Objects::nonNull).collect(Collectors.toList());
        this.latestException = exception;
        this.value = value;
    }

    public EvaluationResult(Object value, EvaluationException exception) {
        this(value, exception, null, null);
    }

    public EvaluationResult(Object value) {
        this.value = value;
        this.exceptions = new ArrayList<EvaluationException>();
        this.latestException = null;
    }

    public EvaluationResult wrapExceptions(EvaluationResult other) {
        if (other != null && other.exceptions != null) {
            return this.wrapExceptions(other.exceptions);
        }
        return this;
    }

    public EvaluationResult wrapExceptions(List<EvaluationException> exceptions) {
        if (!exceptions.isEmpty()) {
            this.exceptions.addAll(exceptions);
        }
        return this;
    }

    public EvaluationResult copyWithValue(Object value) {
        return new EvaluationResult(value, this.exceptions);
    }

    public EvaluationResult copyWithDefaultValueForType(Type type) {
        Object value;
        switch (type) {
            case STRING: {
                value = "";
                break;
            }
            case INTEGER: {
                value = 0;
                break;
            }
            default: {
                value = false;
            }
        }
        return new EvaluationResult(value, this.exceptions);
    }

    public boolean isMissingAttributeException() {
        return this.latestException != null && this.latestException.getKind() == EvaluationException.ErrorKind.MISSING_ATTRIBUTE;
    }

    @Override
    public Object value() {
        return this.value;
    }

    @Override
    public boolean isFailed() {
        return !this.exceptions.isEmpty();
    }

    @Override
    public Collection<EvaluationException> causes() {
        return this.exceptions != null ? this.exceptions : Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvaluationResult that = (EvaluationResult)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.exceptions, that.exceptions);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.exceptions);
    }

    public String toString() {
        return "EvaluationResult{  value=" + this.value + "\n  , exceptions=" + this.exceptions + "\n" + '}';
    }
}

