/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.xml;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventContext;
import io.cloudevents.CloudEventData;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.CloudEventUtils;
import io.cloudevents.core.format.EventSerializationException;
import io.cloudevents.rw.CloudEventContextReader;
import io.cloudevents.rw.CloudEventContextWriter;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventWriter;
import io.cloudevents.types.Time;
import io.cloudevents.xml.XMLCloudEventData;
import io.cloudevents.xml.XMLUtils;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Base64;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class XMLSerializer {
    XMLSerializer() {
    }

    static Document toDocument(CloudEvent ce) {
        XMLCloudEventWriter eventWriter = new XMLCloudEventWriter(ce.getSpecVersion());
        CloudEventContextReader cloudEventContextReader = CloudEventUtils.toContextReader((CloudEventContext)ce);
        cloudEventContextReader.readContext((CloudEventContextWriter)eventWriter);
        CloudEventData data = ce.getData();
        if (data != null) {
            return eventWriter.end(data);
        }
        return eventWriter.end();
    }

    private static class XMLCloudEventWriter
    implements CloudEventWriter<Document> {
        private final Document xmlDocument;
        private final Element root;
        private final SpecVersion specVersion;
        private String dataContentType;

        XMLCloudEventWriter(SpecVersion specVersion) throws EventSerializationException {
            this.specVersion = specVersion;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder xmlBuilder = null;
            try {
                xmlBuilder = dbf.newDocumentBuilder();
                this.xmlDocument = xmlBuilder.newDocument();
            }
            catch (ParserConfigurationException e) {
                throw new EventSerializationException((Throwable)e);
            }
            this.root = this.xmlDocument.createElementNS("http://cloudevents.io/xmlformat/V1", "event");
            this.root.setAttribute("xmlns:xs", "http://www.w3.org/2001/XMLSchema");
            this.root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.root.setAttribute("specversion", specVersion.toString());
            this.xmlDocument.appendChild(this.root);
        }

        private void addElement(String name, String xsiType, String value) {
            Element e = this.xmlDocument.createElement(name);
            if (!this.specVersion.getAllAttributes().contains(name)) {
                e.setAttribute("xsi:type", xsiType);
            }
            e.setTextContent(value);
            this.root.appendChild(e);
            if ("datacontenttype".equals(name)) {
                this.dataContentType = value;
            }
        }

        private void writeXmlData(Document dataDoc) {
            Element e = this.xmlDocument.createElement("data");
            e.setAttribute("xsi:type", "xs:any");
            this.root.appendChild(e);
            Element dataRoot = dataDoc.getDocumentElement();
            Node newNode = this.xmlDocument.importNode(dataRoot, true);
            e.appendChild(newNode);
        }

        private void writeXmlData(byte[] data) {
            this.writeXmlData(XMLUtils.parseIntoDocument(data));
        }

        public CloudEventContextWriter withContextAttribute(String name, String value) throws CloudEventRWException {
            this.addElement(name, "ce:string", value);
            return this;
        }

        public CloudEventContextWriter withContextAttribute(String name, URI value) throws CloudEventRWException {
            this.addElement(name, "ce:uri", value.toString());
            return this;
        }

        public CloudEventContextWriter withContextAttribute(String name, OffsetDateTime value) throws CloudEventRWException {
            this.addElement(name, "ce:timestamp", Time.writeTime((OffsetDateTime)value));
            return this;
        }

        public CloudEventContextWriter withContextAttribute(String name, Number value) throws CloudEventRWException {
            if (value instanceof Integer) {
                return this.withContextAttribute(name, (Integer)value);
            }
            return this.withContextAttribute(name, String.valueOf(value));
        }

        public CloudEventContextWriter withContextAttribute(String name, Integer value) throws CloudEventRWException {
            this.addElement(name, "ce:integer", value.toString());
            return this;
        }

        public CloudEventContextWriter withContextAttribute(String name, Boolean value) throws CloudEventRWException {
            this.addElement(name, "ce:boolean", value.toString());
            return this;
        }

        public CloudEventContextWriter withContextAttribute(String name, byte[] value) throws CloudEventRWException {
            this.addElement(name, "ce:binary", Base64.getEncoder().encodeToString(value));
            return this;
        }

        public Document end(CloudEventData data) throws CloudEventRWException {
            if (data instanceof XMLCloudEventData) {
                this.writeXmlData(((XMLCloudEventData)data).getDocument());
            } else if (XMLUtils.isXmlContent(this.dataContentType)) {
                this.writeXmlData(data.toBytes());
            } else if (XMLUtils.isTextContent(this.dataContentType)) {
                this.addElement("data", "xs:string", new String(data.toBytes()));
            } else {
                String encodedValue = Base64.getEncoder().encodeToString(data.toBytes());
                this.addElement("data", "xs:base64Binary", encodedValue);
            }
            return this.end();
        }

        public Document end() throws CloudEventRWException {
            return this.xmlDocument;
        }
    }
}

