/*
 * Decompiled with CFR 0.152.
 */
package io.cloudreactor.tasksymphony.api;

import com.fasterxml.jackson.core.type.TypeReference;
import io.cloudreactor.tasksymphony.invoker.ApiClient;
import io.cloudreactor.tasksymphony.invoker.ApiException;
import io.cloudreactor.tasksymphony.invoker.Configuration;
import io.cloudreactor.tasksymphony.invoker.Pair;
import io.cloudreactor.tasksymphony.model.PaginatedRunEnvironmentList;
import io.cloudreactor.tasksymphony.model.PatchedRunEnvironment;
import io.cloudreactor.tasksymphony.model.RunEnvironment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;

public class RunEnvironmentsApi {
    private ApiClient apiClient;

    public RunEnvironmentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RunEnvironmentsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public RunEnvironment runEnvironmentsCloneCreate(UUID uuid, RunEnvironment runEnvironment) throws ApiException {
        RunEnvironment localVarPostBody = runEnvironment;
        if (uuid == null) {
            throw new ApiException(400, "Missing the required parameter 'uuid' when calling runEnvironmentsCloneCreate");
        }
        if (runEnvironment == null) {
            throw new ApiException(400, "Missing the required parameter 'runEnvironment' when calling runEnvironmentsCloneCreate");
        }
        String localVarPath = "/run_environments/{uuid}/clone/".replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"tokenAuth"};
        TypeReference<RunEnvironment> localVarReturnType = new TypeReference<RunEnvironment>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RunEnvironment runEnvironmentsCreate(RunEnvironment runEnvironment) throws ApiException {
        RunEnvironment localVarPostBody = runEnvironment;
        if (runEnvironment == null) {
            throw new ApiException(400, "Missing the required parameter 'runEnvironment' when calling runEnvironmentsCreate");
        }
        String localVarPath = "/run_environments/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"tokenAuth"};
        TypeReference<RunEnvironment> localVarReturnType = new TypeReference<RunEnvironment>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void runEnvironmentsDestroy(UUID uuid) throws ApiException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new ApiException(400, "Missing the required parameter 'uuid' when calling runEnvironmentsDestroy");
        }
        String localVarPath = "/run_environments/{uuid}/".replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"tokenAuth"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public PaginatedRunEnvironmentList runEnvironmentsList(Integer createdByGroupId, Integer limit, String name, Integer offset, String ordering, String search) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/run_environments/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("created_by_group__id", createdByGroupId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("ordering", ordering));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("search", search));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"tokenAuth"};
        TypeReference<PaginatedRunEnvironmentList> localVarReturnType = new TypeReference<PaginatedRunEnvironmentList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RunEnvironment runEnvironmentsPartialUpdate(UUID uuid, PatchedRunEnvironment patchedRunEnvironment) throws ApiException {
        PatchedRunEnvironment localVarPostBody = patchedRunEnvironment;
        if (uuid == null) {
            throw new ApiException(400, "Missing the required parameter 'uuid' when calling runEnvironmentsPartialUpdate");
        }
        String localVarPath = "/run_environments/{uuid}/".replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"tokenAuth"};
        TypeReference<RunEnvironment> localVarReturnType = new TypeReference<RunEnvironment>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RunEnvironment runEnvironmentsRetrieve(UUID uuid) throws ApiException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new ApiException(400, "Missing the required parameter 'uuid' when calling runEnvironmentsRetrieve");
        }
        String localVarPath = "/run_environments/{uuid}/".replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"tokenAuth"};
        TypeReference<RunEnvironment> localVarReturnType = new TypeReference<RunEnvironment>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RunEnvironment runEnvironmentsUpdate(UUID uuid, RunEnvironment runEnvironment) throws ApiException {
        RunEnvironment localVarPostBody = runEnvironment;
        if (uuid == null) {
            throw new ApiException(400, "Missing the required parameter 'uuid' when calling runEnvironmentsUpdate");
        }
        if (runEnvironment == null) {
            throw new ApiException(400, "Missing the required parameter 'runEnvironment' when calling runEnvironmentsUpdate");
        }
        String localVarPath = "/run_environments/{uuid}/".replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"tokenAuth"};
        TypeReference<RunEnvironment> localVarReturnType = new TypeReference<RunEnvironment>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

