/*
 * Decompiled with CFR 0.152.
 */
package io.cloudreactor.tasksymphony.api;

import com.fasterxml.jackson.core.type.TypeReference;
import io.cloudreactor.tasksymphony.invoker.ApiClient;
import io.cloudreactor.tasksymphony.invoker.ApiException;
import io.cloudreactor.tasksymphony.invoker.Configuration;
import io.cloudreactor.tasksymphony.invoker.Pair;
import io.cloudreactor.tasksymphony.model.PaginatedWorkflowTaskInstanceList;
import io.cloudreactor.tasksymphony.model.PatchedWorkflowTaskInstance;
import io.cloudreactor.tasksymphony.model.WorkflowTaskInstance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;

public class WorkflowTaskInstancesApi {
    private ApiClient apiClient;

    public WorkflowTaskInstancesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WorkflowTaskInstancesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public WorkflowTaskInstance workflowTaskInstancesCreate(WorkflowTaskInstance workflowTaskInstance) throws ApiException {
        WorkflowTaskInstance localVarPostBody = workflowTaskInstance;
        if (workflowTaskInstance == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowTaskInstance' when calling workflowTaskInstancesCreate");
        }
        String localVarPath = "/workflow_task_instances/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"tokenAuth"};
        TypeReference<WorkflowTaskInstance> localVarReturnType = new TypeReference<WorkflowTaskInstance>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void workflowTaskInstancesDestroy(UUID uuid) throws ApiException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new ApiException(400, "Missing the required parameter 'uuid' when calling workflowTaskInstancesDestroy");
        }
        String localVarPath = "/workflow_task_instances/{uuid}/".replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"tokenAuth"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public PaginatedWorkflowTaskInstanceList workflowTaskInstancesList(String description, Integer limit, String name, Integer offset, String ordering, String search, String taskName, UUID taskUuid, Integer workflowCreatedByGroupId, UUID workflowRunEnvironmentUuid, UUID workflowUuid) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/workflow_task_instances/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("description", description));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("ordering", ordering));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("search", search));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("task__name", taskName));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("task__uuid", taskUuid));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("workflow__created_by_group__id", workflowCreatedByGroupId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("workflow__run_environment__uuid", workflowRunEnvironmentUuid));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("workflow__uuid", workflowUuid));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"tokenAuth"};
        TypeReference<PaginatedWorkflowTaskInstanceList> localVarReturnType = new TypeReference<PaginatedWorkflowTaskInstanceList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public WorkflowTaskInstance workflowTaskInstancesPartialUpdate(UUID uuid, PatchedWorkflowTaskInstance patchedWorkflowTaskInstance) throws ApiException {
        PatchedWorkflowTaskInstance localVarPostBody = patchedWorkflowTaskInstance;
        if (uuid == null) {
            throw new ApiException(400, "Missing the required parameter 'uuid' when calling workflowTaskInstancesPartialUpdate");
        }
        String localVarPath = "/workflow_task_instances/{uuid}/".replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"tokenAuth"};
        TypeReference<WorkflowTaskInstance> localVarReturnType = new TypeReference<WorkflowTaskInstance>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public WorkflowTaskInstance workflowTaskInstancesRetrieve(UUID uuid) throws ApiException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new ApiException(400, "Missing the required parameter 'uuid' when calling workflowTaskInstancesRetrieve");
        }
        String localVarPath = "/workflow_task_instances/{uuid}/".replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"tokenAuth"};
        TypeReference<WorkflowTaskInstance> localVarReturnType = new TypeReference<WorkflowTaskInstance>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public WorkflowTaskInstance workflowTaskInstancesUpdate(UUID uuid, WorkflowTaskInstance workflowTaskInstance) throws ApiException {
        WorkflowTaskInstance localVarPostBody = workflowTaskInstance;
        if (uuid == null) {
            throw new ApiException(400, "Missing the required parameter 'uuid' when calling workflowTaskInstancesUpdate");
        }
        if (workflowTaskInstance == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowTaskInstance' when calling workflowTaskInstancesUpdate");
        }
        String localVarPath = "/workflow_task_instances/{uuid}/".replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"tokenAuth"};
        TypeReference<WorkflowTaskInstance> localVarReturnType = new TypeReference<WorkflowTaskInstance>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

