/*
 * Decompiled with CFR 0.152.
 */
package io.cloudreactor.tasksymphony.api;

import com.fasterxml.jackson.core.type.TypeReference;
import io.cloudreactor.tasksymphony.invoker.ApiClient;
import io.cloudreactor.tasksymphony.invoker.ApiException;
import io.cloudreactor.tasksymphony.invoker.Configuration;
import io.cloudreactor.tasksymphony.invoker.Pair;
import io.cloudreactor.tasksymphony.model.PaginatedWorkflowTransitionList;
import io.cloudreactor.tasksymphony.model.PatchedWorkflowTransition;
import io.cloudreactor.tasksymphony.model.WorkflowTransition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;

public class WorkflowTransitionsApi {
    private ApiClient apiClient;

    public WorkflowTransitionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WorkflowTransitionsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public WorkflowTransition workflowTransitionsCreate(WorkflowTransition workflowTransition) throws ApiException {
        WorkflowTransition localVarPostBody = workflowTransition;
        if (workflowTransition == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowTransition' when calling workflowTransitionsCreate");
        }
        String localVarPath = "/workflow_transitions/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"tokenAuth"};
        TypeReference<WorkflowTransition> localVarReturnType = new TypeReference<WorkflowTransition>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void workflowTransitionsDestroy(UUID uuid) throws ApiException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new ApiException(400, "Missing the required parameter 'uuid' when calling workflowTransitionsDestroy");
        }
        String localVarPath = "/workflow_transitions/{uuid}/".replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"tokenAuth"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public PaginatedWorkflowTransitionList workflowTransitionsList(String description, Integer limit, Integer offset, String ordering, String search) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/workflow_transitions/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("description", description));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("ordering", ordering));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("search", search));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"tokenAuth"};
        TypeReference<PaginatedWorkflowTransitionList> localVarReturnType = new TypeReference<PaginatedWorkflowTransitionList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public WorkflowTransition workflowTransitionsPartialUpdate(UUID uuid, PatchedWorkflowTransition patchedWorkflowTransition) throws ApiException {
        PatchedWorkflowTransition localVarPostBody = patchedWorkflowTransition;
        if (uuid == null) {
            throw new ApiException(400, "Missing the required parameter 'uuid' when calling workflowTransitionsPartialUpdate");
        }
        String localVarPath = "/workflow_transitions/{uuid}/".replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"tokenAuth"};
        TypeReference<WorkflowTransition> localVarReturnType = new TypeReference<WorkflowTransition>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public WorkflowTransition workflowTransitionsRetrieve(UUID uuid) throws ApiException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new ApiException(400, "Missing the required parameter 'uuid' when calling workflowTransitionsRetrieve");
        }
        String localVarPath = "/workflow_transitions/{uuid}/".replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"tokenAuth"};
        TypeReference<WorkflowTransition> localVarReturnType = new TypeReference<WorkflowTransition>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public WorkflowTransition workflowTransitionsUpdate(UUID uuid, WorkflowTransition workflowTransition) throws ApiException {
        WorkflowTransition localVarPostBody = workflowTransition;
        if (uuid == null) {
            throw new ApiException(400, "Missing the required parameter 'uuid' when calling workflowTransitionsUpdate");
        }
        if (workflowTransition == null) {
            throw new ApiException(400, "Missing the required parameter 'workflowTransition' when calling workflowTransitionsUpdate");
        }
        String localVarPath = "/workflow_transitions/{uuid}/".replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"tokenAuth"};
        TypeReference<WorkflowTransition> localVarReturnType = new TypeReference<WorkflowTransition>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

