/*
 * Decompiled with CFR 0.152.
 */
package io.cloudreactor.tasksymphony.api;

import com.fasterxml.jackson.core.type.TypeReference;
import io.cloudreactor.tasksymphony.invoker.ApiClient;
import io.cloudreactor.tasksymphony.invoker.ApiException;
import io.cloudreactor.tasksymphony.invoker.Configuration;
import io.cloudreactor.tasksymphony.invoker.Pair;
import io.cloudreactor.tasksymphony.model.PaginatedWorkflowSummaryList;
import io.cloudreactor.tasksymphony.model.PatchedWorkflow;
import io.cloudreactor.tasksymphony.model.Workflow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;

public class WorkflowsApi {
    private ApiClient apiClient;

    public WorkflowsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WorkflowsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Workflow workflowsCloneCreate(UUID uuid, Workflow workflow) throws ApiException {
        Workflow localVarPostBody = workflow;
        if (uuid == null) {
            throw new ApiException(400, "Missing the required parameter 'uuid' when calling workflowsCloneCreate");
        }
        if (workflow == null) {
            throw new ApiException(400, "Missing the required parameter 'workflow' when calling workflowsCloneCreate");
        }
        String localVarPath = "/workflows/{uuid}/clone/".replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"tokenAuth"};
        TypeReference<Workflow> localVarReturnType = new TypeReference<Workflow>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Workflow workflowsCreate(Workflow workflow) throws ApiException {
        Workflow localVarPostBody = workflow;
        if (workflow == null) {
            throw new ApiException(400, "Missing the required parameter 'workflow' when calling workflowsCreate");
        }
        String localVarPath = "/workflows/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"tokenAuth"};
        TypeReference<Workflow> localVarReturnType = new TypeReference<Workflow>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void workflowsDestroy(UUID uuid) throws ApiException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new ApiException(400, "Missing the required parameter 'uuid' when calling workflowsDestroy");
        }
        String localVarPath = "/workflows/{uuid}/".replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"tokenAuth"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public PaginatedWorkflowSummaryList workflowsList(String description, Integer limit, String name, Integer offset, String ordering, String runEnvironmentUuid, String search) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/workflows/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("description", description));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("ordering", ordering));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("run_environment__uuid", runEnvironmentUuid));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("search", search));
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"tokenAuth"};
        TypeReference<PaginatedWorkflowSummaryList> localVarReturnType = new TypeReference<PaginatedWorkflowSummaryList>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Workflow workflowsPartialUpdate(UUID uuid, PatchedWorkflow patchedWorkflow) throws ApiException {
        PatchedWorkflow localVarPostBody = patchedWorkflow;
        if (uuid == null) {
            throw new ApiException(400, "Missing the required parameter 'uuid' when calling workflowsPartialUpdate");
        }
        String localVarPath = "/workflows/{uuid}/".replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"tokenAuth"};
        TypeReference<Workflow> localVarReturnType = new TypeReference<Workflow>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Workflow workflowsRetrieve(UUID uuid) throws ApiException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new ApiException(400, "Missing the required parameter 'uuid' when calling workflowsRetrieve");
        }
        String localVarPath = "/workflows/{uuid}/".replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"tokenAuth"};
        TypeReference<Workflow> localVarReturnType = new TypeReference<Workflow>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Workflow workflowsUpdate(UUID uuid, Workflow workflow) throws ApiException {
        Workflow localVarPostBody = workflow;
        if (uuid == null) {
            throw new ApiException(400, "Missing the required parameter 'uuid' when calling workflowsUpdate");
        }
        if (workflow == null) {
            throw new ApiException(400, "Missing the required parameter 'workflow' when calling workflowsUpdate");
        }
        String localVarPath = "/workflows/{uuid}/".replaceAll("\\{uuid\\}", this.apiClient.escapeString(uuid.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "application/x-www-form-urlencoded", "multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"tokenAuth"};
        TypeReference<Workflow> localVarReturnType = new TypeReference<Workflow>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

