/*
 * Decompiled with CFR 0.152.
 */
package io.cloudreactor.tasksymphony.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.cloudreactor.tasksymphony.model.Group;
import io.cloudreactor.tasksymphony.model.NameAndUuid;
import io.cloudreactor.tasksymphony.model.NotificationSeverity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="An AlertMethod specifies one or more configured methods of notifying users or external sources of events that trigger when one or more conditions are satisfied.")
@JsonPropertyOrder(value={"url", "uuid", "name", "description", "dashboard_url", "enabled", "method_details", "notify_on_success", "notify_on_failure", "notify_on_timeout", "error_severity_on_missing_execution", "error_severity_on_missing_heartbeat", "error_severity_on_service_down", "created_by_user", "created_by_group", "run_environment", "created_at", "updated_at"})
@JsonTypeName(value="AlertMethod")
public class AlertMethod {
    public static final String JSON_PROPERTY_URL = "url";
    private URI url;
    public static final String JSON_PROPERTY_UUID = "uuid";
    private UUID uuid;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DASHBOARD_URL = "dashboard_url";
    private String dashboardUrl;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled;
    public static final String JSON_PROPERTY_METHOD_DETAILS = "method_details";
    private Map<String, Object> methodDetails = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_NOTIFY_ON_SUCCESS = "notify_on_success";
    private Boolean notifyOnSuccess;
    public static final String JSON_PROPERTY_NOTIFY_ON_FAILURE = "notify_on_failure";
    private Boolean notifyOnFailure;
    public static final String JSON_PROPERTY_NOTIFY_ON_TIMEOUT = "notify_on_timeout";
    private Boolean notifyOnTimeout;
    public static final String JSON_PROPERTY_ERROR_SEVERITY_ON_MISSING_EXECUTION = "error_severity_on_missing_execution";
    private NotificationSeverity errorSeverityOnMissingExecution;
    public static final String JSON_PROPERTY_ERROR_SEVERITY_ON_MISSING_HEARTBEAT = "error_severity_on_missing_heartbeat";
    private NotificationSeverity errorSeverityOnMissingHeartbeat;
    public static final String JSON_PROPERTY_ERROR_SEVERITY_ON_SERVICE_DOWN = "error_severity_on_service_down";
    private NotificationSeverity errorSeverityOnServiceDown;
    public static final String JSON_PROPERTY_CREATED_BY_USER = "created_by_user";
    private String createdByUser;
    public static final String JSON_PROPERTY_CREATED_BY_GROUP = "created_by_group";
    private Group createdByGroup;
    public static final String JSON_PROPERTY_RUN_ENVIRONMENT = "run_environment";
    private JsonNullable<NameAndUuid> runEnvironment = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private OffsetDateTime updatedAt;

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public URI getUrl() {
        return this.url;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="uuid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getUuid() {
        return this.uuid;
    }

    public AlertMethod name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public AlertMethod description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="dashboard_url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDashboardUrl() {
        return this.dashboardUrl;
    }

    public AlertMethod enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="method_details")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.ALWAYS)
    public Map<String, Object> getMethodDetails() {
        return this.methodDetails;
    }

    public AlertMethod notifyOnSuccess(Boolean notifyOnSuccess) {
        this.notifyOnSuccess = notifyOnSuccess;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="notify_on_success")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getNotifyOnSuccess() {
        return this.notifyOnSuccess;
    }

    @JsonProperty(value="notify_on_success")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNotifyOnSuccess(Boolean notifyOnSuccess) {
        this.notifyOnSuccess = notifyOnSuccess;
    }

    public AlertMethod notifyOnFailure(Boolean notifyOnFailure) {
        this.notifyOnFailure = notifyOnFailure;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="notify_on_failure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getNotifyOnFailure() {
        return this.notifyOnFailure;
    }

    @JsonProperty(value="notify_on_failure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNotifyOnFailure(Boolean notifyOnFailure) {
        this.notifyOnFailure = notifyOnFailure;
    }

    public AlertMethod notifyOnTimeout(Boolean notifyOnTimeout) {
        this.notifyOnTimeout = notifyOnTimeout;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="notify_on_timeout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getNotifyOnTimeout() {
        return this.notifyOnTimeout;
    }

    @JsonProperty(value="notify_on_timeout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNotifyOnTimeout(Boolean notifyOnTimeout) {
        this.notifyOnTimeout = notifyOnTimeout;
    }

    public AlertMethod errorSeverityOnMissingExecution(NotificationSeverity errorSeverityOnMissingExecution) {
        this.errorSeverityOnMissingExecution = errorSeverityOnMissingExecution;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="error_severity_on_missing_execution")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NotificationSeverity getErrorSeverityOnMissingExecution() {
        return this.errorSeverityOnMissingExecution;
    }

    @JsonProperty(value="error_severity_on_missing_execution")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrorSeverityOnMissingExecution(NotificationSeverity errorSeverityOnMissingExecution) {
        this.errorSeverityOnMissingExecution = errorSeverityOnMissingExecution;
    }

    public AlertMethod errorSeverityOnMissingHeartbeat(NotificationSeverity errorSeverityOnMissingHeartbeat) {
        this.errorSeverityOnMissingHeartbeat = errorSeverityOnMissingHeartbeat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="error_severity_on_missing_heartbeat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NotificationSeverity getErrorSeverityOnMissingHeartbeat() {
        return this.errorSeverityOnMissingHeartbeat;
    }

    @JsonProperty(value="error_severity_on_missing_heartbeat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrorSeverityOnMissingHeartbeat(NotificationSeverity errorSeverityOnMissingHeartbeat) {
        this.errorSeverityOnMissingHeartbeat = errorSeverityOnMissingHeartbeat;
    }

    public AlertMethod errorSeverityOnServiceDown(NotificationSeverity errorSeverityOnServiceDown) {
        this.errorSeverityOnServiceDown = errorSeverityOnServiceDown;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="error_severity_on_service_down")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NotificationSeverity getErrorSeverityOnServiceDown() {
        return this.errorSeverityOnServiceDown;
    }

    @JsonProperty(value="error_severity_on_service_down")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrorSeverityOnServiceDown(NotificationSeverity errorSeverityOnServiceDown) {
        this.errorSeverityOnServiceDown = errorSeverityOnServiceDown;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.")
    @JsonProperty(value="created_by_user")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCreatedByUser() {
        return this.createdByUser;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="created_by_group")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Group getCreatedByGroup() {
        return this.createdByGroup;
    }

    public AlertMethod runEnvironment(NameAndUuid runEnvironment) {
        this.runEnvironment = JsonNullable.of((Object)runEnvironment);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public NameAndUuid getRunEnvironment() {
        return (NameAndUuid)this.runEnvironment.orElse(null);
    }

    @JsonProperty(value="run_environment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<NameAndUuid> getRunEnvironment_JsonNullable() {
        return this.runEnvironment;
    }

    @JsonProperty(value="run_environment")
    public void setRunEnvironment_JsonNullable(JsonNullable<NameAndUuid> runEnvironment) {
        this.runEnvironment = runEnvironment;
    }

    public void setRunEnvironment(NameAndUuid runEnvironment) {
        this.runEnvironment = JsonNullable.of((Object)runEnvironment);
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlertMethod alertMethod = (AlertMethod)o;
        return Objects.equals(this.url, alertMethod.url) && Objects.equals(this.uuid, alertMethod.uuid) && Objects.equals(this.name, alertMethod.name) && Objects.equals(this.description, alertMethod.description) && Objects.equals(this.dashboardUrl, alertMethod.dashboardUrl) && Objects.equals(this.enabled, alertMethod.enabled) && Objects.equals(this.methodDetails, alertMethod.methodDetails) && Objects.equals(this.notifyOnSuccess, alertMethod.notifyOnSuccess) && Objects.equals(this.notifyOnFailure, alertMethod.notifyOnFailure) && Objects.equals(this.notifyOnTimeout, alertMethod.notifyOnTimeout) && Objects.equals((Object)this.errorSeverityOnMissingExecution, (Object)alertMethod.errorSeverityOnMissingExecution) && Objects.equals((Object)this.errorSeverityOnMissingHeartbeat, (Object)alertMethod.errorSeverityOnMissingHeartbeat) && Objects.equals((Object)this.errorSeverityOnServiceDown, (Object)alertMethod.errorSeverityOnServiceDown) && Objects.equals(this.createdByUser, alertMethod.createdByUser) && Objects.equals(this.createdByGroup, alertMethod.createdByGroup) && AlertMethod.equalsNullable(this.runEnvironment, alertMethod.runEnvironment) && Objects.equals(this.createdAt, alertMethod.createdAt) && Objects.equals(this.updatedAt, alertMethod.updatedAt);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.url, this.uuid, this.name, this.description, this.dashboardUrl, this.enabled, this.methodDetails, this.notifyOnSuccess, this.notifyOnFailure, this.notifyOnTimeout, this.errorSeverityOnMissingExecution, this.errorSeverityOnMissingHeartbeat, this.errorSeverityOnServiceDown, this.createdByUser, this.createdByGroup, AlertMethod.hashCodeNullable(this.runEnvironment), this.createdAt, this.updatedAt});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlertMethod {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dashboardUrl: ").append(this.toIndentedString(this.dashboardUrl)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    methodDetails: ").append(this.toIndentedString(this.methodDetails)).append("\n");
        sb.append("    notifyOnSuccess: ").append(this.toIndentedString(this.notifyOnSuccess)).append("\n");
        sb.append("    notifyOnFailure: ").append(this.toIndentedString(this.notifyOnFailure)).append("\n");
        sb.append("    notifyOnTimeout: ").append(this.toIndentedString(this.notifyOnTimeout)).append("\n");
        sb.append("    errorSeverityOnMissingExecution: ").append(this.toIndentedString((Object)this.errorSeverityOnMissingExecution)).append("\n");
        sb.append("    errorSeverityOnMissingHeartbeat: ").append(this.toIndentedString((Object)this.errorSeverityOnMissingHeartbeat)).append("\n");
        sb.append("    errorSeverityOnServiceDown: ").append(this.toIndentedString((Object)this.errorSeverityOnServiceDown)).append("\n");
        sb.append("    createdByUser: ").append(this.toIndentedString(this.createdByUser)).append("\n");
        sb.append("    createdByGroup: ").append(this.toIndentedString(this.createdByGroup)).append("\n");
        sb.append("    runEnvironment: ").append(this.toIndentedString(this.runEnvironment)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

