/*
 * Decompiled with CFR 0.152.
 */
package io.cloudreactor.tasksymphony.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.cloudreactor.tasksymphony.model.AwsEcsLaunchType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="AwsEcsExecutionMethods contain configuration for running Tasks in AWS ECS.")
@JsonPropertyOrder(value={"type", "task_definition_arn", "task_definition_infrastructure_website_url", "allocated_cpu_units", "allocated_memory_mb", "tags", "subnets", "subnet_infrastructure_website_urls", "security_groups", "security_group_infrastructure_website_urls", "assign_public_ip", "task_arn", "launch_type", "cluster_arn", "cluster_infrastructure_website_url", "execution_role", "execution_role_infrastructure_website_url", "task_role", "task_role_infrastructure_website_url", "platform_version"})
@JsonTypeName(value="AwsEcsExecutionMethod")
public class AwsEcsExecutionMethod {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_TASK_DEFINITION_ARN = "task_definition_arn";
    private String taskDefinitionArn;
    public static final String JSON_PROPERTY_TASK_DEFINITION_INFRASTRUCTURE_WEBSITE_URL = "task_definition_infrastructure_website_url";
    private String taskDefinitionInfrastructureWebsiteUrl;
    public static final String JSON_PROPERTY_ALLOCATED_CPU_UNITS = "allocated_cpu_units";
    private Integer allocatedCpuUnits;
    public static final String JSON_PROPERTY_ALLOCATED_MEMORY_MB = "allocated_memory_mb";
    private Integer allocatedMemoryMb;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private Map<String, String> tags = new HashMap<String, String>();
    public static final String JSON_PROPERTY_SUBNETS = "subnets";
    private List<String> subnets = null;
    public static final String JSON_PROPERTY_SUBNET_INFRASTRUCTURE_WEBSITE_URLS = "subnet_infrastructure_website_urls";
    private List<String> subnetInfrastructureWebsiteUrls = new ArrayList<String>();
    public static final String JSON_PROPERTY_SECURITY_GROUPS = "security_groups";
    private List<String> securityGroups = null;
    public static final String JSON_PROPERTY_SECURITY_GROUP_INFRASTRUCTURE_WEBSITE_URLS = "security_group_infrastructure_website_urls";
    private List<String> securityGroupInfrastructureWebsiteUrls = new ArrayList<String>();
    public static final String JSON_PROPERTY_ASSIGN_PUBLIC_IP = "assign_public_ip";
    private Boolean assignPublicIp;
    public static final String JSON_PROPERTY_TASK_ARN = "task_arn";
    private String taskArn;
    public static final String JSON_PROPERTY_LAUNCH_TYPE = "launch_type";
    private JsonNullable<AwsEcsLaunchType> launchType = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CLUSTER_ARN = "cluster_arn";
    private String clusterArn;
    public static final String JSON_PROPERTY_CLUSTER_INFRASTRUCTURE_WEBSITE_URL = "cluster_infrastructure_website_url";
    private String clusterInfrastructureWebsiteUrl;
    public static final String JSON_PROPERTY_EXECUTION_ROLE = "execution_role";
    private String executionRole;
    public static final String JSON_PROPERTY_EXECUTION_ROLE_INFRASTRUCTURE_WEBSITE_URL = "execution_role_infrastructure_website_url";
    private String executionRoleInfrastructureWebsiteUrl;
    public static final String JSON_PROPERTY_TASK_ROLE = "task_role";
    private String taskRole;
    public static final String JSON_PROPERTY_TASK_ROLE_INFRASTRUCTURE_WEBSITE_URL = "task_role_infrastructure_website_url";
    private String taskRoleInfrastructureWebsiteUrl;
    public static final String JSON_PROPERTY_PLATFORM_VERSION = "platform_version";
    private String platformVersion;

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    public AwsEcsExecutionMethod taskDefinitionArn(String taskDefinitionArn) {
        this.taskDefinitionArn = taskDefinitionArn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="task_definition_arn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTaskDefinitionArn() {
        return this.taskDefinitionArn;
    }

    @JsonProperty(value="task_definition_arn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTaskDefinitionArn(String taskDefinitionArn) {
        this.taskDefinitionArn = taskDefinitionArn;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="task_definition_infrastructure_website_url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTaskDefinitionInfrastructureWebsiteUrl() {
        return this.taskDefinitionInfrastructureWebsiteUrl;
    }

    public AwsEcsExecutionMethod allocatedCpuUnits(Integer allocatedCpuUnits) {
        this.allocatedCpuUnits = allocatedCpuUnits;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="allocated_cpu_units")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAllocatedCpuUnits() {
        return this.allocatedCpuUnits;
    }

    @JsonProperty(value="allocated_cpu_units")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllocatedCpuUnits(Integer allocatedCpuUnits) {
        this.allocatedCpuUnits = allocatedCpuUnits;
    }

    public AwsEcsExecutionMethod allocatedMemoryMb(Integer allocatedMemoryMb) {
        this.allocatedMemoryMb = allocatedMemoryMb;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="allocated_memory_mb")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAllocatedMemoryMb() {
        return this.allocatedMemoryMb;
    }

    @JsonProperty(value="allocated_memory_mb")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllocatedMemoryMb(Integer allocatedMemoryMb) {
        this.allocatedMemoryMb = allocatedMemoryMb;
    }

    public AwsEcsExecutionMethod tags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public AwsEcsExecutionMethod putTagsItem(String key, String tagsItem) {
        this.tags.put(key, tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="tags")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.ALWAYS)
    public Map<String, String> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.ALWAYS)
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public AwsEcsExecutionMethod subnets(List<String> subnets) {
        this.subnets = subnets;
        return this;
    }

    public AwsEcsExecutionMethod addSubnetsItem(String subnetsItem) {
        if (this.subnets == null) {
            this.subnets = new ArrayList<String>();
        }
        this.subnets.add(subnetsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="subnets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSubnets() {
        return this.subnets;
    }

    @JsonProperty(value="subnets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubnets(List<String> subnets) {
        this.subnets = subnets;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="subnet_infrastructure_website_urls")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getSubnetInfrastructureWebsiteUrls() {
        return this.subnetInfrastructureWebsiteUrls;
    }

    public AwsEcsExecutionMethod securityGroups(List<String> securityGroups) {
        this.securityGroups = securityGroups;
        return this;
    }

    public AwsEcsExecutionMethod addSecurityGroupsItem(String securityGroupsItem) {
        if (this.securityGroups == null) {
            this.securityGroups = new ArrayList<String>();
        }
        this.securityGroups.add(securityGroupsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="security_groups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSecurityGroups() {
        return this.securityGroups;
    }

    @JsonProperty(value="security_groups")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecurityGroups(List<String> securityGroups) {
        this.securityGroups = securityGroups;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="security_group_infrastructure_website_urls")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getSecurityGroupInfrastructureWebsiteUrls() {
        return this.securityGroupInfrastructureWebsiteUrls;
    }

    public AwsEcsExecutionMethod assignPublicIp(Boolean assignPublicIp) {
        this.assignPublicIp = assignPublicIp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="assign_public_ip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAssignPublicIp() {
        return this.assignPublicIp;
    }

    @JsonProperty(value="assign_public_ip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAssignPublicIp(Boolean assignPublicIp) {
        this.assignPublicIp = assignPublicIp;
    }

    public AwsEcsExecutionMethod taskArn(String taskArn) {
        this.taskArn = taskArn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="task_arn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTaskArn() {
        return this.taskArn;
    }

    @JsonProperty(value="task_arn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTaskArn(String taskArn) {
        this.taskArn = taskArn;
    }

    public AwsEcsExecutionMethod launchType(AwsEcsLaunchType launchType) {
        this.launchType = JsonNullable.of((Object)((Object)launchType));
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public AwsEcsLaunchType getLaunchType() {
        return (AwsEcsLaunchType)((Object)this.launchType.orElse(null));
    }

    @JsonProperty(value="launch_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<AwsEcsLaunchType> getLaunchType_JsonNullable() {
        return this.launchType;
    }

    @JsonProperty(value="launch_type")
    public void setLaunchType_JsonNullable(JsonNullable<AwsEcsLaunchType> launchType) {
        this.launchType = launchType;
    }

    public void setLaunchType(AwsEcsLaunchType launchType) {
        this.launchType = JsonNullable.of((Object)((Object)launchType));
    }

    public AwsEcsExecutionMethod clusterArn(String clusterArn) {
        this.clusterArn = clusterArn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="cluster_arn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClusterArn() {
        return this.clusterArn;
    }

    @JsonProperty(value="cluster_arn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClusterArn(String clusterArn) {
        this.clusterArn = clusterArn;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="cluster_infrastructure_website_url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getClusterInfrastructureWebsiteUrl() {
        return this.clusterInfrastructureWebsiteUrl;
    }

    public AwsEcsExecutionMethod executionRole(String executionRole) {
        this.executionRole = executionRole;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="execution_role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExecutionRole() {
        return this.executionRole;
    }

    @JsonProperty(value="execution_role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExecutionRole(String executionRole) {
        this.executionRole = executionRole;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="execution_role_infrastructure_website_url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getExecutionRoleInfrastructureWebsiteUrl() {
        return this.executionRoleInfrastructureWebsiteUrl;
    }

    public AwsEcsExecutionMethod taskRole(String taskRole) {
        this.taskRole = taskRole;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="task_role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTaskRole() {
        return this.taskRole;
    }

    @JsonProperty(value="task_role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTaskRole(String taskRole) {
        this.taskRole = taskRole;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="task_role_infrastructure_website_url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTaskRoleInfrastructureWebsiteUrl() {
        return this.taskRoleInfrastructureWebsiteUrl;
    }

    public AwsEcsExecutionMethod platformVersion(String platformVersion) {
        this.platformVersion = platformVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="platform_version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPlatformVersion() {
        return this.platformVersion;
    }

    @JsonProperty(value="platform_version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlatformVersion(String platformVersion) {
        this.platformVersion = platformVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AwsEcsExecutionMethod awsEcsExecutionMethod = (AwsEcsExecutionMethod)o;
        return Objects.equals(this.type, awsEcsExecutionMethod.type) && Objects.equals(this.taskDefinitionArn, awsEcsExecutionMethod.taskDefinitionArn) && Objects.equals(this.taskDefinitionInfrastructureWebsiteUrl, awsEcsExecutionMethod.taskDefinitionInfrastructureWebsiteUrl) && Objects.equals(this.allocatedCpuUnits, awsEcsExecutionMethod.allocatedCpuUnits) && Objects.equals(this.allocatedMemoryMb, awsEcsExecutionMethod.allocatedMemoryMb) && Objects.equals(this.tags, awsEcsExecutionMethod.tags) && Objects.equals(this.subnets, awsEcsExecutionMethod.subnets) && Objects.equals(this.subnetInfrastructureWebsiteUrls, awsEcsExecutionMethod.subnetInfrastructureWebsiteUrls) && Objects.equals(this.securityGroups, awsEcsExecutionMethod.securityGroups) && Objects.equals(this.securityGroupInfrastructureWebsiteUrls, awsEcsExecutionMethod.securityGroupInfrastructureWebsiteUrls) && Objects.equals(this.assignPublicIp, awsEcsExecutionMethod.assignPublicIp) && Objects.equals(this.taskArn, awsEcsExecutionMethod.taskArn) && AwsEcsExecutionMethod.equalsNullable(this.launchType, awsEcsExecutionMethod.launchType) && Objects.equals(this.clusterArn, awsEcsExecutionMethod.clusterArn) && Objects.equals(this.clusterInfrastructureWebsiteUrl, awsEcsExecutionMethod.clusterInfrastructureWebsiteUrl) && Objects.equals(this.executionRole, awsEcsExecutionMethod.executionRole) && Objects.equals(this.executionRoleInfrastructureWebsiteUrl, awsEcsExecutionMethod.executionRoleInfrastructureWebsiteUrl) && Objects.equals(this.taskRole, awsEcsExecutionMethod.taskRole) && Objects.equals(this.taskRoleInfrastructureWebsiteUrl, awsEcsExecutionMethod.taskRoleInfrastructureWebsiteUrl) && Objects.equals(this.platformVersion, awsEcsExecutionMethod.platformVersion);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.type, this.taskDefinitionArn, this.taskDefinitionInfrastructureWebsiteUrl, this.allocatedCpuUnits, this.allocatedMemoryMb, this.tags, this.subnets, this.subnetInfrastructureWebsiteUrls, this.securityGroups, this.securityGroupInfrastructureWebsiteUrls, this.assignPublicIp, this.taskArn, AwsEcsExecutionMethod.hashCodeNullable(this.launchType), this.clusterArn, this.clusterInfrastructureWebsiteUrl, this.executionRole, this.executionRoleInfrastructureWebsiteUrl, this.taskRole, this.taskRoleInfrastructureWebsiteUrl, this.platformVersion);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AwsEcsExecutionMethod {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    taskDefinitionArn: ").append(this.toIndentedString(this.taskDefinitionArn)).append("\n");
        sb.append("    taskDefinitionInfrastructureWebsiteUrl: ").append(this.toIndentedString(this.taskDefinitionInfrastructureWebsiteUrl)).append("\n");
        sb.append("    allocatedCpuUnits: ").append(this.toIndentedString(this.allocatedCpuUnits)).append("\n");
        sb.append("    allocatedMemoryMb: ").append(this.toIndentedString(this.allocatedMemoryMb)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    subnets: ").append(this.toIndentedString(this.subnets)).append("\n");
        sb.append("    subnetInfrastructureWebsiteUrls: ").append(this.toIndentedString(this.subnetInfrastructureWebsiteUrls)).append("\n");
        sb.append("    securityGroups: ").append(this.toIndentedString(this.securityGroups)).append("\n");
        sb.append("    securityGroupInfrastructureWebsiteUrls: ").append(this.toIndentedString(this.securityGroupInfrastructureWebsiteUrls)).append("\n");
        sb.append("    assignPublicIp: ").append(this.toIndentedString(this.assignPublicIp)).append("\n");
        sb.append("    taskArn: ").append(this.toIndentedString(this.taskArn)).append("\n");
        sb.append("    launchType: ").append(this.toIndentedString(this.launchType)).append("\n");
        sb.append("    clusterArn: ").append(this.toIndentedString(this.clusterArn)).append("\n");
        sb.append("    clusterInfrastructureWebsiteUrl: ").append(this.toIndentedString(this.clusterInfrastructureWebsiteUrl)).append("\n");
        sb.append("    executionRole: ").append(this.toIndentedString(this.executionRole)).append("\n");
        sb.append("    executionRoleInfrastructureWebsiteUrl: ").append(this.toIndentedString(this.executionRoleInfrastructureWebsiteUrl)).append("\n");
        sb.append("    taskRole: ").append(this.toIndentedString(this.taskRole)).append("\n");
        sb.append("    taskRoleInfrastructureWebsiteUrl: ").append(this.toIndentedString(this.taskRoleInfrastructureWebsiteUrl)).append("\n");
        sb.append("    platformVersion: ").append(this.toIndentedString(this.platformVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

